/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.urlfilter.automaton;

import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.urlfilter.api.RegexRule;
import org.apache.nutch.urlfilter.api.RegexURLFilterBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomatonURLFilter
extends RegexURLFilterBase {
    public static final String URLFILTER_AUTOMATON_FILE = "urlfilter.automaton.file";
    public static final String URLFILTER_AUTOMATON_RULES = "urlfilter.automaton.rules";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public AutomatonURLFilter() {
    }

    public AutomatonURLFilter(String filename) throws IOException, PatternSyntaxException {
        super(filename);
    }

    AutomatonURLFilter(Reader reader) throws IOException, IllegalArgumentException {
        super(reader);
    }

    protected Reader getRulesReader(Configuration conf) throws IOException {
        String stringRules = conf.get(URLFILTER_AUTOMATON_RULES);
        if (stringRules != null) {
            LOG.info("Reading urlfilter-automaton string rules from property: {}", (Object)URLFILTER_AUTOMATON_RULES);
            return new StringReader(stringRules);
        }
        String fileRules = conf.get(URLFILTER_AUTOMATON_FILE);
        LOG.info("Reading urlfilter-automaton rules file: {}", (Object)fileRules);
        return conf.getConfResourceAsReader(fileRules);
    }

    protected RegexRule createRule(boolean sign, String regex) {
        return new Rule(sign, regex);
    }

    protected RegexRule createRule(boolean sign, String regex, String hostOrDomain) {
        return new Rule(sign, regex, hostOrDomain);
    }

    public static void main(String[] args) throws IOException {
        AutomatonURLFilter.main((RegexURLFilterBase)new AutomatonURLFilter(), (String[])args);
    }

    private class Rule
    extends RegexRule {
        private RunAutomaton automaton;

        Rule(boolean sign, String regex) {
            super(sign, regex);
            this.automaton = new RunAutomaton(new RegExp(regex, 65535).toAutomaton());
        }

        Rule(boolean sign, String regex, String hostOrDomain) {
            super(sign, regex, hostOrDomain);
            this.automaton = new RunAutomaton(new RegExp(regex, 65535).toAutomaton());
        }

        protected boolean match(String url) {
            return this.automaton.run(url);
        }
    }
}

