/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;

public class PluginClassLoader
extends URLClassLoader {
    private URL[] urls;
    private ClassLoader parent;
    private ClassLoader system = PluginClassLoader.getSystemClassLoader();

    public PluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.urls = urls;
        this.parent = parent;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException | SecurityException e) {
                c = this.loadClassFromParent(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private Class<?> loadClassFromParent(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        try {
            c = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            c = this.loadClassFromSystem(name);
        }
        catch (SecurityException e) {
            c = this.loadClassFromSystem(name);
        }
        return c;
    }

    private Class<?> loadClassFromSystem(String name) throws ClassNotFoundException {
        Class<?> c = null;
        if (this.system != null) {
            c = this.system.loadClass(name);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        if (url == null && this.system != null) {
            url = this.system.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> systemUrls = null;
        if (this.system != null) {
            systemUrls = this.system.getResources(name);
        }
        Enumeration<URL> localUrls = this.findResources(name);
        Enumeration<URL> parentUrls = null;
        if (this.getParent() != null) {
            parentUrls = this.getParent().getResources(name);
        }
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (localUrls != null) {
            while (localUrls.hasMoreElements()) {
                URL local = localUrls.nextElement();
                urls.add(local);
            }
        }
        if (systemUrls != null) {
            while (systemUrls.hasMoreElements()) {
                urls.add(systemUrls.nextElement());
            }
        }
        if (parentUrls != null) {
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + Arrays.hashCode(this.urls);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginClassLoader other = (PluginClassLoader)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return Arrays.equals(this.urls, other.urls);
    }
}

