/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.okhttp;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Base64;
import java.util.Locale;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.CaseInsensitiveMetadata;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.net.protocols.HttpDateFormat;
import org.apache.nutch.net.protocols.Response;
import org.apache.nutch.protocol.ProtocolException;
import org.apache.nutch.protocol.http.api.HttpBase;
import org.apache.nutch.protocol.okhttp.OkHttp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpResponse
implements org.apache.nutch.net.protocols.Response {
    protected static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private URL url;
    private byte[] content;
    private int code;
    private Metadata headers = new Metadata();

    public OkHttpResponse(OkHttp okhttp, URL url, CrawlDatum datum) throws ProtocolException, IOException {
        this.url = url;
        Request.Builder rb = new Request.Builder().url(url);
        rb.header("User-Agent", okhttp.getUserAgent());
        okhttp.getCustomRequestHeaders().forEach(k -> rb.header(k[0], k[1]));
        if (okhttp.isIfModifiedSinceEnabled() && datum.getModifiedTime() > 0L) {
            rb.header("If-Modified-Since", HttpDateFormat.toString((long)datum.getModifiedTime()));
        }
        if (okhttp.isCookieEnabled()) {
            String cookie = null;
            if (datum.getMetaData().containsKey((Object)HttpBase.COOKIE)) {
                cookie = ((Text)datum.getMetaData().get((Object)HttpBase.COOKIE)).toString();
            }
            if (cookie == null) {
                cookie = okhttp.getCookie(url);
            }
            if (cookie != null) {
                rb.header("Cookie", cookie);
            }
        }
        Request request = rb.build();
        Call call = okhttp.getClient(url).newCall(request);
        try (Response response = call.execute();){
            CaseInsensitiveMetadata responsemetadata = new CaseInsensitiveMetadata();
            Headers httpHeaders = response.headers();
            int size = httpHeaders.size();
            for (int i = 0; i < size; ++i) {
                String key = httpHeaders.name(i);
                String value = httpHeaders.value(i);
                if (key.equals("_request_") || key.equals("_response.headers_")) {
                    value = new String(Base64.getDecoder().decode(value));
                }
                responsemetadata.add(key, value);
            }
            LOG.debug("{} - {} {} {}", new Object[]{url, response.protocol(), response.code(), response.message()});
            TruncatedContent truncated = new TruncatedContent();
            this.content = this.toByteArray(response.body(), truncated, okhttp.getMaxContent(), okhttp.getMaxDuration(), okhttp.isStorePartialAsTruncated());
            responsemetadata.add("nutch.fetch.time", Long.toString(System.currentTimeMillis()));
            if (truncated.booleanValue()) {
                if (!call.isCanceled()) {
                    call.cancel();
                }
                responsemetadata.set("http.content.truncated", "true");
                responsemetadata.set("http.content.truncated.reason", truncated.getReason().toString().toLowerCase(Locale.ROOT));
                LOG.debug("HTTP content truncated to {} bytes (reason: {})", (Object)this.content.length, (Object)truncated.getReason());
            }
            this.code = response.code();
            this.headers = responsemetadata;
        }
    }

    private final byte[] toByteArray(ResponseBody responseBody, TruncatedContent truncated, int maxContent, int maxDuration, boolean partialAsTruncated) throws IOException {
        int bytesBuffered;
        if (responseBody == null) {
            return new byte[0];
        }
        long endDueFor = -1L;
        if (maxDuration != -1) {
            endDueFor = System.currentTimeMillis() + (long)(maxDuration * 1000);
        }
        int maxContentBytes = Integer.MAX_VALUE;
        if (maxContent >= 0) {
            maxContentBytes = Math.min(maxContentBytes, maxContent);
        }
        BufferedSource source = responseBody.source();
        int bytesRequested = 0;
        int bufferGrowStepBytes = 8192;
        while (source.getBuffer().size() <= (long)maxContentBytes) {
            bytesRequested += Math.min(bufferGrowStepBytes, (maxContentBytes == Integer.MAX_VALUE ? maxContentBytes : 1 + maxContentBytes) - bytesRequested);
            boolean success = false;
            try {
                success = source.request((long)bytesRequested);
            }
            catch (IOException e) {
                if (partialAsTruncated && source.getBuffer().size() > 0L) {
                    truncated.setReason(Response.TruncatedContentReason.DISCONNECT);
                    LOG.info("Truncated content for {}, partial fetch caused by:", (Object)this.url, (Object)e);
                }
                throw e;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("total bytes requested = {}, buffered = {}", (Object)bytesRequested, (Object)source.getBuffer().size());
            }
            if (!success) {
                LOG.debug("source exhausted, no more data to read");
                break;
            }
            if (endDueFor != -1L && endDueFor <= System.currentTimeMillis()) {
                LOG.debug("max. fetch duration reached");
                truncated.setReason(Response.TruncatedContentReason.TIME);
                break;
            }
            if (source.getBuffer().size() >= (long)maxContentBytes) {
                LOG.debug("content limit reached");
            }
            bytesRequested = (int)source.getBuffer().size();
        }
        int bytesToCopy = bytesBuffered = (int)source.getBuffer().size();
        if (maxContent >= 0 && bytesToCopy > maxContent) {
            truncated.setReason(Response.TruncatedContentReason.LENGTH);
            bytesToCopy = maxContentBytes;
        }
        byte[] arr = new byte[bytesToCopy];
        source.getBuffer().readFully(arr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("copied {} bytes out of {} buffered, remaining {} bytes in buffer", new Object[]{bytesToCopy, bytesBuffered, source.getBuffer().size()});
        }
        return arr;
    }

    public URL getUrl() {
        return this.url;
    }

    public int getCode() {
        return this.code;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Metadata getHeaders() {
        return this.headers;
    }

    public byte[] getContent() {
        return this.content;
    }

    public static class TruncatedContent {
        private Response.TruncatedContentReason value = Response.TruncatedContentReason.NOT_TRUNCATED;

        public void setReason(Response.TruncatedContentReason val) {
            this.value = val;
        }

        public Response.TruncatedContentReason getReason() {
            return this.value;
        }

        public boolean booleanValue() {
            return this.value != Response.TruncatedContentReason.NOT_TRUNCATED;
        }
    }
}

