/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.tracing.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum StreamFormat {
    JSON("json"),
    PROTO("proto");

    private String value;

    private StreamFormat(String value) {
        this.value = value;
    }

    public static StreamFormat fromString(String s) {
        return Arrays.stream(StreamFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within StreamFormat "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static StreamFormat fromJson(JsonInput input) {
        return StreamFormat.fromString(input.nextString());
    }
}

