/*
 * Decompiled with CFR 0.152.
 */
package org.archive.net.rsync;

import java.io.File;
import java.net.URL;
import org.archive.net.DownloadURLConnection;

public class RsyncURLConnection
extends DownloadURLConnection {
    private final String RSYNC_TIMEOUT = System.getProperty(RsyncURLConnection.class.getName() + ".timeout", "300");

    protected RsyncURLConnection(URL u) {
        super(u);
    }

    @Override
    protected String getScript() {
        return System.getProperty(this.getClass().getName() + ".path", "rsync");
    }

    @Override
    protected String[] getCommand(URL thisUrl, File downloadFile) {
        return new String[]{this.getScript(), "--timeout=" + this.RSYNC_TIMEOUT, this.url.getPath(), downloadFile.getAbsolutePath()};
    }
}

