/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.security.user.privileges.ApplicationResourcePrivileges;
import org.elasticsearch.client.security.user.privileges.IndicesPrivileges;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class HasPrivilegesRequest
implements Validatable,
ToXContentObject {
    private final Set<String> clusterPrivileges;
    private final Set<IndicesPrivileges> indexPrivileges;
    private final Set<ApplicationResourcePrivileges> applicationPrivileges;

    public HasPrivilegesRequest(@Nullable Set<String> clusterPrivileges, @Nullable Set<IndicesPrivileges> indexPrivileges, @Nullable Set<ApplicationResourcePrivileges> applicationPrivileges) {
        this.clusterPrivileges = clusterPrivileges == null ? Collections.emptySet() : Collections.unmodifiableSet(clusterPrivileges);
        this.indexPrivileges = indexPrivileges == null ? Collections.emptySet() : Collections.unmodifiableSet(indexPrivileges);
        Set<Object> set = this.applicationPrivileges = applicationPrivileges == null ? Collections.emptySet() : Collections.unmodifiableSet(applicationPrivileges);
        if (this.clusterPrivileges.isEmpty() && this.indexPrivileges.isEmpty() && this.applicationPrivileges.isEmpty()) {
            throw new IllegalArgumentException("At last 1 privilege must be specified");
        }
    }

    public Set<String> getClusterPrivileges() {
        return this.clusterPrivileges;
    }

    public Set<IndicesPrivileges> getIndexPrivileges() {
        return this.indexPrivileges;
    }

    public Set<ApplicationResourcePrivileges> getApplicationPrivileges() {
        return this.applicationPrivileges;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("cluster", this.clusterPrivileges).field("index", this.indexPrivileges).field("application", this.applicationPrivileges).endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasPrivilegesRequest that = (HasPrivilegesRequest)o;
        return Objects.equals(this.clusterPrivileges, that.clusterPrivileges) && Objects.equals(this.indexPrivileges, that.indexPrivileges) && Objects.equals(this.applicationPrivileges, that.applicationPrivileges);
    }

    public int hashCode() {
        return Objects.hash(this.clusterPrivileges, this.indexPrivileges, this.applicationPrivileges);
    }
}

