/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.commons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BasicJsonUtils {
    public static Map<String, Object> toPropertiesMap(JsonObject jsonProps) {
        Map<String, Object> map;
        if (jsonProps != null) {
            map = new HashMap();
            for (Map.Entry e : jsonProps.entrySet()) {
                map.put((String)e.getKey(), BasicJsonUtils.convertValue((JsonElement)e.getValue()));
            }
        } else {
            map = Collections.emptyMap();
        }
        return map;
    }

    private static Object convertValue(JsonElement value) {
        if (value.isJsonNull()) {
            return null;
        }
        if (value.isJsonPrimitive()) {
            JsonPrimitive prim = value.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isNumber()) {
                Number n = prim.getAsNumber();
                if (n.doubleValue() == (double)n.intValue()) {
                    return n.intValue();
                }
                return n.doubleValue();
            }
            if (prim.isString()) {
                return prim.getAsString();
            }
            throw new RuntimeException("Unrecognized value: " + String.valueOf(value));
        }
        return value.toString();
    }
}

