/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.cdx;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import org.netpreserve.jwarc.cdx.JsonException;
import org.netpreserve.jwarc.cdx.JsonToken;

class JsonTokenizer {
    private final Reader reader;
    private final StringBuilder buffer = new StringBuilder();
    private final Deque<JsonToken> context = new ArrayDeque<JsonToken>();
    private final int maxStringLength;
    private final int maxDepth;
    private JsonToken currentToken;
    private int currentCharacter;
    private boolean reconsuming;

    public JsonTokenizer(Reader reader) {
        this(reader, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public JsonTokenizer(Reader reader, int maxDepth, int maxStringLength) {
        this.reader = reader;
        this.maxDepth = maxDepth;
        this.maxStringLength = maxStringLength;
    }

    private int read() throws IOException {
        if (this.reconsuming) {
            this.reconsuming = false;
        } else {
            this.currentCharacter = this.reader.read();
        }
        return this.currentCharacter;
    }

    private int readSkippingWhitespace() throws IOException {
        int c;
        while ((c = this.read()) == 32 || c == 10 || c == 13 || c == 9) {
        }
        return c;
    }

    public JsonToken nextToken() throws IOException, JsonException {
        this.currentToken = this.currentToken == JsonToken.START_OBJECT ? this.tokenizeFieldName() : (this.currentToken == null || this.currentToken == JsonToken.START_ARRAY || this.currentToken == JsonToken.FIELD_NAME ? this.tokenizeValue() : this.tokenizeAfterValue());
        return this.currentToken;
    }

    public String stringValue() {
        return this.buffer.toString();
    }

    private JsonToken tokenizeFieldName() throws IOException, JsonException {
        switch (this.readSkippingWhitespace()) {
            case 34: {
                this.consumeString();
                if (this.readSkippingWhitespace() != 58) {
                    throw new JsonException("Expected :");
                }
                return JsonToken.FIELD_NAME;
            }
            case 125: {
                if (this.context.pollLast() != JsonToken.END_OBJECT) {
                    throw new JsonException("Unexpected }");
                }
                return JsonToken.END_OBJECT;
            }
            case -1: {
                throw new JsonException("Unexpected end of input");
            }
        }
        throw new JsonException("Unexpected character: " + (char)this.currentCharacter);
    }

    private JsonToken tokenizeValue() throws IOException, JsonException {
        switch (this.readSkippingWhitespace()) {
            case -1: {
                if (!this.context.isEmpty()) {
                    throw new JsonException("Unexpected end of input");
                }
                return null;
            }
            case 123: {
                if (this.context.size() >= this.maxDepth) {
                    throw new JsonException("Exceeded max depth");
                }
                this.context.addLast(JsonToken.START_OBJECT);
                return JsonToken.START_OBJECT;
            }
            case 91: {
                if (this.context.size() >= this.maxDepth) {
                    throw new JsonException("Exceeded max depth");
                }
                this.context.addLast(JsonToken.START_ARRAY);
                return JsonToken.START_ARRAY;
            }
            case 125: {
                if (this.context.pollLast() != JsonToken.START_OBJECT) {
                    throw new JsonException("Unexpected }");
                }
                return JsonToken.END_OBJECT;
            }
            case 93: {
                if (this.context.pollLast() != JsonToken.START_ARRAY) {
                    throw new JsonException("Unexpected ]");
                }
                return JsonToken.END_ARRAY;
            }
            case 102: {
                return this.consume("alse", JsonToken.FALSE);
            }
            case 116: {
                return this.consume("rue", JsonToken.TRUE);
            }
            case 110: {
                return this.consume("ull", JsonToken.NULL);
            }
            case 34: {
                return this.consumeString();
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.consumeNumber();
            }
        }
        throw new JsonException("Unexpected character: " + (char)this.currentCharacter);
    }

    private JsonToken tokenizeAfterValue() throws IOException, JsonException {
        switch (this.readSkippingWhitespace()) {
            case -1: {
                if (!this.context.isEmpty()) {
                    throw new JsonException("Unexpected end of input");
                }
                return null;
            }
            case 44: {
                if (this.context.isEmpty()) {
                    throw new JsonException("Unexpected ,");
                }
                if (this.context.peekLast() == JsonToken.START_OBJECT) {
                    return this.tokenizeFieldName();
                }
                return this.tokenizeValue();
            }
            case 125: {
                if (this.context.pollLast() != JsonToken.START_OBJECT) {
                    throw new JsonException("Unexpected }");
                }
                return JsonToken.END_OBJECT;
            }
            case 93: {
                if (this.context.pollLast() != JsonToken.START_ARRAY) {
                    throw new JsonException("Unexpected ]");
                }
                return JsonToken.END_ARRAY;
            }
        }
        throw new JsonException("Unexpected character");
    }

    private JsonToken consumeNumber() throws IOException {
        this.buffer.setLength(0);
        this.buffer.append((char)this.currentCharacter);
        JsonToken result = JsonToken.NUMBER_INT;
        block5: while (true) {
            int c = this.read();
            switch (c) {
                case -1: {
                    return result;
                }
                case 43: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.buffer.append((char)c);
                    continue block5;
                }
                case 46: 
                case 69: 
                case 101: {
                    result = JsonToken.NUMBER_FLOAT;
                    this.buffer.append((char)c);
                    continue block5;
                }
            }
            break;
        }
        this.reconsuming = true;
        return result;
    }

    private JsonToken consumeString() throws IOException, JsonException {
        this.buffer.setLength(0);
        block15: while (true) {
            int c = this.read();
            switch (c) {
                case -1: {
                    throw new JsonException("Unterminated string");
                }
                case 34: {
                    return JsonToken.STRING;
                }
                case 92: {
                    int escapedChar;
                    c = this.read();
                    switch (c) {
                        case -1: {
                            throw new JsonException("Unterminated string");
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            escapedChar = c;
                            break;
                        }
                        case 98: {
                            escapedChar = 8;
                            break;
                        }
                        case 102: {
                            escapedChar = 12;
                            break;
                        }
                        case 110: {
                            escapedChar = 10;
                            break;
                        }
                        case 114: {
                            escapedChar = 13;
                            break;
                        }
                        case 116: {
                            escapedChar = 9;
                            break;
                        }
                        case 117: {
                            escapedChar = 0;
                            for (int i = 0; i < 4; ++i) {
                                c = this.read();
                                if (c == -1) {
                                    throw new JsonException("Unterminated string");
                                }
                                int digit = Character.digit(c, 16);
                                if (digit == -1) {
                                    throw new JsonException("Expected hex digit");
                                }
                                escapedChar = escapedChar * 16 + digit;
                            }
                            break;
                        }
                        default: {
                            throw new JsonException("Invalid escape sequence: \\" + (char)this.currentCharacter);
                        }
                    }
                    if (this.buffer.length() >= this.maxStringLength) continue block15;
                    this.buffer.append((char)escapedChar);
                    continue block15;
                }
            }
            if (this.buffer.length() >= this.maxStringLength) continue;
            this.buffer.append((char)c);
        }
    }

    private JsonToken consume(String expected, JsonToken token) throws IOException, JsonException {
        for (int i = 0; i < expected.length(); ++i) {
            if (this.read() == expected.charAt(i)) continue;
            throw new JsonException("Expected " + expected);
        }
        return token;
    }

    public JsonToken currentToken() {
        return this.currentToken;
    }
}

