/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.settings;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.ActiveThemeProvider;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.string.Strings;

public class SessionThemeProvider
implements ActiveThemeProvider {
    @Override
    public ITheme getActiveTheme() {
        String style = this.loadThemeName();
        ThemeProvider themeProvider = this.themeProvider();
        if (Strings.isEmpty((String)style)) {
            return themeProvider.defaultTheme();
        }
        return themeProvider.byName(style);
    }

    @Override
    public void setActiveTheme(String themeName) {
        ThemeProvider themeProvider = this.themeProvider();
        ITheme theme = themeProvider.byName(themeName);
        this.setActiveTheme(theme);
    }

    @Override
    public void setActiveTheme(ITheme theme) {
        if (theme != null) {
            this.storeThemeName(theme.name());
        } else {
            this.storeThemeName(null);
        }
    }

    protected String loadThemeName() {
        return Session.get().getStyle();
    }

    protected void storeThemeName(String themeName) {
        Session session = Session.get();
        this.assertBoundSession(session);
        session.setStyle(themeName);
    }

    protected void assertBoundSession(Session session) {
        if (session.isTemporary()) {
            session.bind();
        }
    }

    private ThemeProvider themeProvider() {
        if (Application.exists()) {
            return Bootstrap.getSettings().getThemeProvider();
        }
        throw new WicketRuntimeException("no application assigned to current thread");
    }
}

