/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.anonymous;

import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;

public class AnonymousNegotiator
implements SaslNegotiator {
    private final AuthenticationResult _anonymousAuthenticationResult;
    private volatile boolean _isComplete;

    public AnonymousNegotiator(AuthenticationResult anonymousAuthenticationResult) {
        this._anonymousAuthenticationResult = anonymousAuthenticationResult;
    }

    @Override
    public AuthenticationResult handleResponse(byte[] response) {
        if (this._isComplete) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalStateException("Multiple Authentications not permitted."));
        }
        this._isComplete = true;
        return this._anonymousAuthenticationResult;
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getAttemptedAuthenticationId() {
        return this._anonymousAuthenticationResult.getMainPrincipal().getName();
    }
}

