/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.logic;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.InExpression;

public class NotExpression<T, R>
extends AbstractExpressionNode<T, Boolean>
implements Predicate<T> {
    public NotExpression(Expression<T, R> source) {
        super((ExpressionNode)source);
        if (source instanceof InExpression) {
            List children = ((InExpression)source).getChildren();
            ExpressionNode left = this.getChild(0).getChildren().get(0);
            this._metadata.setAlias(left.getAlias() + " not in (" + children.subList(1, children.size()).stream().map(ExpressionNode::getAlias).collect(Collectors.joining(",")) + ")");
        } else {
            this._metadata.setAlias("not" + ((ExpressionNode)source).getAlias());
        }
    }

    @Override
    public Boolean apply(T value) {
        Predicate source = (Predicate)((Object)this.getChild(0));
        return !source.test(value);
    }

    @Override
    public boolean test(T value) {
        return (Boolean)this.apply((Object)value);
    }
}

