/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;

class TemporalDuration
implements TemporalAccessor {
    private static final Temporal BASE = LocalDateTime.of(0, 1, 1, 0, 0, 0, 0);
    private static final DateTimeFormatter dtf = new DateTimeFormatterBuilder().optionalStart().appendValue(ChronoField.YEAR).appendLiteral(" years ").optionalEnd().optionalStart().appendLiteral(' ').appendValue(ChronoField.MONTH_OF_YEAR).appendLiteral(" months ").optionalEnd().optionalStart().appendLiteral(' ').appendValue(ChronoField.DAY_OF_MONTH).appendLiteral(" days ").optionalEnd().optionalStart().appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY).appendLiteral(" hours ").optionalEnd().optionalStart().appendLiteral(' ').appendValue(ChronoField.MINUTE_OF_HOUR).appendLiteral(" minutes ").optionalEnd().optionalStart().appendLiteral(' ').appendValue(ChronoField.SECOND_OF_MINUTE).appendLiteral(" seconds").optionalEnd().optionalStart().appendLiteral(' ').appendValue(ChronoField.MILLI_OF_SECOND).appendLiteral(" milliseconds").optionalEnd().toFormatter();
    private final Duration duration;
    private final Temporal temporal;

    TemporalDuration(Duration duration) {
        this.duration = duration;
        this.temporal = duration.addTo(BASE);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (!this.temporal.isSupported(field)) {
            return false;
        }
        return this.temporal.getLong(field) - BASE.getLong(field) != 0L;
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (!this.isSupported(temporalField)) {
            throw new UnsupportedTemporalTypeException(temporalField.toString());
        }
        return this.temporal.getLong(temporalField) - BASE.getLong(temporalField);
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String toString() {
        if (this.duration.compareTo(Duration.ofMillis(1L)) < 0) {
            return this.duration.toNanos() + " nanoseconds";
        }
        return dtf.format(this).trim();
    }

    static String formatAsString(Duration duration) {
        return new TemporalDuration(duration).toString();
    }
}

