/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority;

import com.netflix.config.ConfigurationManager;
import jakarta.annotation.PreDestroy;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.servicecomb.config.priority.PriorityProperty;
import org.apache.servicecomb.config.priority.PriorityPropertyType;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.springframework.stereotype.Component;

@Component
public class PriorityPropertyFactory {
    private final AbstractConfiguration configuration;
    private final ConfigurationListener configurationListener = this::configurationListener;
    private final Map<PriorityPropertyType<?>, PriorityProperty<?>> properties = new ConcurrentHashMapEx();

    public PriorityPropertyFactory() {
        this.configuration = ConfigurationManager.getConfigInstance();
        this.configuration.addConfigurationListener(this.configurationListener);
    }

    @PreDestroy
    public void onDestroy() {
        this.configuration.removeConfigurationListener(this.configurationListener);
    }

    public Stream<PriorityProperty<?>> getProperties() {
        return this.properties.values().stream();
    }

    private void configurationListener(ConfigurationEvent event) {
        if (event.isBeforeUpdate()) {
            return;
        }
        this.getProperties().forEach(PriorityProperty::updateValue);
    }

    public <T> PriorityProperty<T> getOrCreate(Type type, T invalidValue, T defaultValue, String ... priorityKeys) {
        PriorityPropertyType<T> propertyType = new PriorityPropertyType<T>(type, invalidValue, defaultValue, priorityKeys);
        return this.properties.computeIfAbsent(propertyType, PriorityProperty::new);
    }
}

