/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageOutputStream;
import org.apache.sis.io.stream.ChannelData;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.ChannelImageInputStream;
import org.apache.sis.io.stream.Markable;

public class ChannelImageOutputStream
extends OutputStream
implements ImageOutputStream,
Markable {
    private final ChannelImageInputStream input;
    private final ChannelDataOutput output;
    private boolean writing;

    public ChannelImageOutputStream(String filename, ByteChannel channel, ByteBuffer buffer) throws IOException {
        this.input = new ChannelImageInputStream(filename, channel, buffer, true);
        this.output = new ChannelDataOutput(filename, channel, buffer);
    }

    public ChannelImageOutputStream(ChannelDataOutput output) throws IOException {
        this.output = output;
        this.input = new ChannelImageInputStream(output.filename, (ReadableByteChannel)((Object)output.channel), output.buffer, true);
        this.writing = true;
    }

    private ChannelData current() {
        return this.writing ? this.output : this.input;
    }

    public final ChannelImageInputStream input() throws IOException {
        if (this.writing) {
            this.output.yield(this.input);
            this.writing = false;
        }
        return this.input;
    }

    public final ChannelDataOutput output() throws IOException {
        if (!this.writing) {
            this.input.yield(this.output);
            this.writing = true;
        }
        return this.output;
    }

    @Override
    public boolean isCached() {
        return this.input.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        return this.input.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        return this.input.isCachedFile();
    }

    @Override
    public long length() throws IOException {
        return this.current().length();
    }

    @Override
    public void mark() {
        this.current().mark();
    }

    @Override
    public void reset() throws IOException {
        this.current().reset();
    }

    @Override
    public void reset(long p) throws IOException {
        this.current().reset(p);
    }

    @Override
    public void seek(long p) throws IOException {
        this.current().seek(p);
    }

    @Override
    public void flushBefore(long p) throws IOException {
        this.current().flushBefore(p);
    }

    @Override
    public long getFlushedPosition() {
        return this.current().getFlushedPosition();
    }

    @Override
    public long getStreamPosition() {
        return this.current().getStreamPosition();
    }

    @Override
    public int getBitOffset() {
        return this.current().getBitOffset();
    }

    @Override
    public void setBitOffset(int n) {
        this.current().setBitOffset(n);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.input.getByteOrder();
    }

    @Override
    public void setByteOrder(ByteOrder v) {
        this.input.setByteOrder(v);
    }

    @Override
    public void readBytes(IIOByteBuffer v, int n) throws IOException {
        this.input().readBytes(v, n);
    }

    @Override
    public int read() throws IOException {
        return this.input().read();
    }

    @Override
    public int readBit() throws IOException {
        return this.input().readBit();
    }

    @Override
    public long readBits(int n) throws IOException {
        return this.input().readBits(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.input().readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.input().readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.input().readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.input().readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.input().readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.input().readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.input().readInt();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return this.input().readUnsignedInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.input().readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.input().readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.input().readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.input().readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.input().readUTF();
    }

    @Override
    public int read(byte[] v) throws IOException {
        return this.input().read(v);
    }

    @Override
    public int read(byte[] v, int s, int n) throws IOException {
        return this.input().read(v, s, n);
    }

    @Override
    public void readFully(byte[] v) throws IOException {
        this.input().readFully(v);
    }

    @Override
    public void readFully(byte[] v, int s, int n) throws IOException {
        this.input().readFully(v, s, n);
    }

    @Override
    public void readFully(short[] v, int s, int n) throws IOException {
        this.input().readFully(v, s, n);
    }

    @Override
    public void readFully(char[] v, int s, int n) throws IOException {
        this.input().readFully(v, s, n);
    }

    @Override
    public void readFully(int[] v, int s, int n) throws IOException {
        this.input().readFully(v, s, n);
    }

    @Override
    public void readFully(long[] v, int s, int n) throws IOException {
        this.input().readFully(v, s, n);
    }

    @Override
    public void readFully(float[] v, int s, int n) throws IOException {
        this.input().readFully(v, s, n);
    }

    @Override
    public void readFully(double[] v, int s, int n) throws IOException {
        this.input().readFully(v, s, n);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.input().skipBytes(n);
    }

    @Override
    public long skipBytes(long n) throws IOException {
        return this.input().skipBytes(n);
    }

    @Override
    public void write(int v) throws IOException {
        this.output().write(v);
    }

    @Override
    public void writeBit(int v) throws IOException {
        this.output().writeBit(v);
    }

    @Override
    public void writeBits(long v, int n) throws IOException {
        this.output().writeBits(v, n);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.output().writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.output().writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.output().writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.output().writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.output().writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.output().writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.output().writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.output().writeDouble(v);
    }

    @Override
    public void writeBytes(String v) throws IOException {
        this.output().writeBytes(v);
    }

    @Override
    public void writeChars(String v) throws IOException {
        this.output().writeChars(v);
    }

    @Override
    public void writeUTF(String v) throws IOException {
        this.output().writeUTF(v);
    }

    @Override
    public void write(byte[] v) throws IOException {
        this.output().write(v);
    }

    @Override
    public void write(byte[] v, int s, int n) throws IOException {
        this.output().write(v, s, n);
    }

    @Override
    public void writeShorts(short[] v, int s, int n) throws IOException {
        this.output().writeShorts(v, s, n);
    }

    @Override
    public void writeChars(char[] v, int s, int n) throws IOException {
        this.output().writeChars(v, s, n);
    }

    @Override
    public void writeInts(int[] v, int s, int n) throws IOException {
        this.output().writeInts(v, s, n);
    }

    @Override
    public void writeLongs(long[] v, int s, int n) throws IOException {
        this.output().writeLongs(v, s, n);
    }

    @Override
    public void writeFloats(float[] v, int s, int n) throws IOException {
        this.output().writeFloats(v, s, n);
    }

    @Override
    public void writeDoubles(double[] v, int s, int n) throws IOException {
        this.output().writeDoubles(v, s, n);
    }

    @Override
    public void flush() throws IOException {
        this.current().flushBefore(this.getStreamPosition());
    }

    @Override
    public void close() throws IOException {
        try (WritableByteChannel writableByteChannel = this.output.channel;){
            if (this.writing) {
                this.output.flush();
            }
        }
    }
}

