/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.IncompatibleResourceException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.WritableAggregate;
import org.apache.sis.storage.base.SimpleAggregate;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.util.GenericName;

public final class WritableAggregateSupport
implements Localized {
    private final WritableAggregate target;

    public WritableAggregateSupport(WritableAggregate target) {
        this.target = target;
    }

    public final Locale getLocale() {
        return this.target instanceof Localized ? ((Localized)this.target).getLocale() : null;
    }

    public Resource writeComponents(Aggregate resource) throws DataStoreException {
        try {
            Collection<? extends Resource> components = resource.components();
            ArrayList<Resource> effectives = new ArrayList<Resource>(components.size());
            for (Resource resource2 : components) {
                effectives.add(this.target.add(resource2));
            }
            return new SimpleAggregate(this.target, effectives);
        }
        catch (BackingStoreException e) {
            throw (DataStoreException)e.unwrapOrRethrow(DataStoreException.class);
        }
    }

    public GridCoverageResource asGridCoverage(Resource resource) throws DataStoreException {
        if (Objects.requireNonNull(resource) instanceof GridCoverageResource) {
            return (GridCoverageResource)resource;
        }
        throw new IncompatibleResourceException(this.message(GridCoverageResource.class, resource)).addAspect("class");
    }

    private String message(Class<? extends Resource> expected, Resource actual) throws DataStoreException {
        Class type = actual.getClass();
        for (Class t : Classes.getLeafInterfaces(type, Resource.class)) {
            if (!Modifier.isPublic(t.getModifiers())) continue;
            type = t;
            break;
        }
        return Resources.forLocale(this.getLocale()).getString((short)80, this.target.getIdentifier().map(GenericName::toString).orElse(Classes.getShortName(actual.getClass())), expected, type);
    }
}

