/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.reader;

import java.util.Locale;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.geotiff.base.Resources;
import org.apache.sis.storage.geotiff.reader.XMLMetadata;
import org.apache.sis.util.resources.Errors;

public final class ImageMetadataBuilder
extends MetadataBuilder {
    private double resolution = Double.NaN;
    private Unit<Length> resolutionUnit = Units.INCH;
    private short cellWidth = (short)-1;
    private short cellHeight = (short)-1;
    private XMLMetadata complement;

    public Integer setThreshholding(int value) {
        switch (value) {
            default: {
                return value;
            }
            case 2: {
                if ((this.cellWidth & this.cellHeight) >= 0) break;
            }
            case 1: 
            case 3: {
                this.cellWidth = this.cellHeight = (short)(-value);
            }
        }
        return null;
    }

    public void setCellSize(short size, boolean w) {
        if (w) {
            this.cellWidth = size;
        } else {
            this.cellHeight = size;
        }
    }

    public void setResolution(double r) {
        if (Double.isNaN(this.resolution) || r > this.resolution) {
            this.resolution = r;
        }
    }

    public Integer setResolutionUnit(int unit) {
        switch (unit) {
            case 1: {
                this.resolutionUnit = null;
                break;
            }
            case 2: {
                this.resolutionUnit = Units.INCH;
                break;
            }
            case 3: {
                this.resolutionUnit = Units.CENTIMETRE;
                break;
            }
            default: {
                return unit;
            }
        }
        return null;
    }

    public void addXML(XMLMetadata xml) {
        if (this.complement == null) {
            this.complement = xml;
        } else {
            xml.appendTo(this.complement);
        }
    }

    public void finish(GeoTiffStore store, StoreListeners listeners) throws DataStoreException {
        if (!Double.isNaN(this.resolution) && this.resolutionUnit != null) {
            this.addLinearResolution(this.resolutionUnit.getConverterTo(Units.METRE).convert(this.resolution));
        }
        switch (Math.min(this.cellWidth, this.cellHeight)) {
            case -1: {
                break;
            }
            case -3: {
                this.addProcessDescription((CharSequence)Resources.formatInternational((short)15));
                break;
            }
            default: {
                this.addProcessDescription((CharSequence)Resources.formatInternational((short)5, this.cellWidth >= 0 ? (int)this.cellWidth : 63, this.cellHeight >= 0 ? (int)this.cellHeight : 63));
            }
        }
        while (this.complement != null) {
            try {
                this.complement = this.complement.appendTo(this);
            }
            catch (Exception ex) {
                listeners.warning(Errors.forLocale((Locale)listeners.getLocale()).getString((short)24, (Object)this.complement.tag()), ex);
            }
        }
    }
}

