/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.internal.shared.Formulas;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.provider.Spherical2Dto3D;
import org.apache.sis.referencing.operation.provider.Spherical3Dto2D;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.CopyTransform;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.OnewayLinearTransform;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform;
import org.apache.sis.referencing.operation.transform.TransformJoiner;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class EllipsoidToRadiusTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -3724386806353023273L;
    private static final int SRC_DIM = 2;
    private static final int TGT_DIM = 3;
    private static ParameterDescriptorGroup DESCRIPTOR;
    final ContextualParameters context;
    protected final double eccentricitySquared;
    private final Inverse inverse;
    private static final CopyTransform DELEGATE;
    private static ParameterDescriptorGroup INVERSE_DESCRIPTOR;

    public EllipsoidToRadiusTransform(Ellipsoid surface) {
        ArgumentChecks.ensureNonNull((String)"surface", (Object)surface);
        DefaultEllipsoid ellipsoid = DefaultEllipsoid.castOrCopy(surface);
        this.eccentricitySquared = ellipsoid.getEccentricitySquared();
        Unit<Length> unit = ellipsoid.getAxisUnit();
        this.context = new ContextualParameters(Spherical2Dto3D.PARAMETERS, 2, 3);
        this.context.getOrCreate(MapProjection.SEMI_MAJOR).setValue(ellipsoid.getSemiMajorAxis(), unit);
        this.context.getOrCreate(MapProjection.SEMI_MINOR).setValue(ellipsoid.getSemiMinorAxis(), unit);
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        normalize.convertBefore(1, (Number)DoubleDouble.DEGREES_TO_RADIANS, null);
        denormalize.convertAfter(1, (Number)DoubleDouble.RADIANS_TO_DEGREES, null);
        denormalize.convertAfter(2, (Number)DoubleDouble.of((double)ellipsoid.getSemiMinorAxis(), (boolean)true), null);
        this.inverse = new Inverse();
    }

    public static MathTransform createGeodeticConversion(MathTransformFactory factory, Ellipsoid surface) throws FactoryException {
        if (Formulas.isEllipsoidal(surface)) {
            try {
                EllipsoidToRadiusTransform kernel;
                MathTransform complete;
                MathTransform inverse;
                if (factory instanceof DefaultMathTransformFactory) {
                    factory = ((DefaultMathTransformFactory)factory).caching(false);
                }
                if ((inverse = (complete = kernel.context.completeTransform(factory, kernel = new EllipsoidToRadiusTransform(surface))).inverse()) instanceof LinearTransform) {
                    ConcatenatedTransform.setInverse(complete, new OnewayLinearTransform.Concatenated((LinearTransform)inverse, kernel.inverse, complete));
                }
                return complete;
            }
            catch (NoninvertibleTransformException e) {
                throw new FactoryException((Throwable)e);
            }
        }
        MatrixSIS m = Matrices.createDiagonal(4, 3);
        m.setElement(3, 2, 1.0);
        m.setElement(2, 2, surface.getSemiMajorAxis());
        return new ProjectiveTransform(m);
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameters pg = Parameters.castOrWrap(this.getParameterDescriptors().createValue());
        pg.getOrCreate(MapProjection.ECCENTRICITY).setValue(Math.sqrt(this.eccentricitySquared));
        return pg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Class<EllipsoidToRadiusTransform> clazz = EllipsoidToRadiusTransform.class;
        synchronized (EllipsoidToRadiusTransform.class) {
            if (DESCRIPTOR == null) {
                ParameterBuilder builder = (ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.SIS, "SIS");
                DESCRIPTOR = ((ParameterBuilder)builder.addName("Spherical2D to 3D (radians domain)")).createGroup(1, 1, MapProjection.ECCENTRICITY);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DESCRIPTOR;
        }
    }

    @Override
    public final int getSourceDimensions() {
        return 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 3;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double \u03a9 = srcPts[srcOff + 1];
        double cos\u03a9 = Math.cos(\u03a9);
        double r2 = 1.0 - this.eccentricitySquared * (cos\u03a9 * cos\u03a9);
        double r = Math.sqrt(r2);
        if (dstPts != null) {
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = \u03a9;
            dstPts[dstOff + 2] = 1.0 / r;
        }
        if (!derivate) {
            return null;
        }
        MatrixSIS derivative = Matrices.createDiagonal(3, 2);
        derivative.setElement(2, 1, this.eccentricitySquared * cos\u03a9 * Math.sin(\u03a9) / (r * r2));
        return derivative;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = 2;
        int dstInc = 3;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, 2, dstOff, 3, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * 2;
                    dstOff += (numPts - 1) * 3;
                    srcInc = -2;
                    dstInc = -3;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * 2);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double \u03a9 = srcPts[srcOff + 1];
            double cos\u03a9 = Math.cos(\u03a9);
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = \u03a9;
            dstPts[dstOff + 2] = 1.0 / Math.sqrt(1.0 - this.eccentricitySquared * (cos\u03a9 * cos\u03a9));
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    @Override
    protected void tryConcatenate(TransformJoiner context) throws FactoryException {
        if (!context.removeUnusedDimensions(1, 2, 3, MathTransforms::identity) && !context.replacePassThrough(Map.of(0, 0))) {
            super.tryConcatenate(context);
        }
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Double.hashCode(this.eccentricitySquared);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            EllipsoidToRadiusTransform that = (EllipsoidToRadiusTransform)object;
            return Numerics.equals((double)this.eccentricitySquared, (double)that.eccentricitySquared);
        }
        return false;
    }

    static {
        DELEGATE = new CopyTransform(3, new int[]{0, 1});
    }

    private final class Inverse
    extends OnewayLinearTransform
    implements Parameterized {
        private static final long serialVersionUID = -5804154207223293418L;

        Inverse() {
            super(DELEGATE);
        }

        @Override
        public MathTransform inverse() {
            return EllipsoidToRadiusTransform.this;
        }

        @Override
        protected ContextualParameters getContextualParameters() {
            return EllipsoidToRadiusTransform.this.context.inverse(Spherical3Dto2D.PARAMETERS, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            Class<EllipsoidToRadiusTransform> clazz = EllipsoidToRadiusTransform.class;
            synchronized (EllipsoidToRadiusTransform.class) {
                if (INVERSE_DESCRIPTOR == null) {
                    INVERSE_DESCRIPTOR = ReferencingUtilities.rename(EllipsoidToRadiusTransform.this.getParameterDescriptors(), "Spherical3D to 2D (radians domain)");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INVERSE_DESCRIPTOR;
            }
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            ParameterValueGroup pg = this.getParameterDescriptors().createValue();
            pg.values().addAll(EllipsoidToRadiusTransform.this.getParameterValues().values());
            return pg;
        }
    }
}

