/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Event;
import org.opengis.metadata.acquisition.PlatformPass;

@XmlType(name="MI_PlatformPass_Type", propOrder={"identifier", "extent", "relatedEvents"})
@XmlRootElement(name="MI_PlatformPass")
public class DefaultPlatformPass
extends ISOMetadata
implements PlatformPass {
    private static final long serialVersionUID = -6447077434254133293L;
    private Geometry extent;
    private Collection<Event> relatedEvents;

    public DefaultPlatformPass() {
    }

    public DefaultPlatformPass(PlatformPass object) {
        super(object);
        if (object != null) {
            this.identifiers = DefaultPlatformPass.singleton(object.getIdentifier(), Identifier.class);
            this.extent = object.getExtent();
            this.relatedEvents = DefaultPlatformPass.copyCollection(object.getRelatedEvents(), Event.class);
        }
    }

    public static DefaultPlatformPass castOrCopy(PlatformPass object) {
        if (object == null || object instanceof DefaultPlatformPass) {
            return (DefaultPlatformPass)object;
        }
        return new DefaultPlatformPass(object);
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier newValue) {
        super.setIdentifier(newValue);
    }

    @XmlElement(name="extent")
    public Geometry getExtent() {
        return this.extent;
    }

    public void setExtent(Geometry newValue) {
        this.checkWritePermission(this.extent);
        this.extent = newValue;
    }

    @XmlElement(name="relatedEvent")
    public Collection<Event> getRelatedEvents() {
        this.relatedEvents = this.nonNullCollection(this.relatedEvents, Event.class);
        return this.relatedEvents;
    }

    public void setRelatedEvents(Collection<? extends Event> newValues) {
        this.relatedEvents = this.writeCollection(newValues, this.relatedEvents, Event.class);
    }
}

