/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.csv;

import java.lang.reflect.Array;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.internal.shared.MovingFeatures;
import org.apache.sis.geometry.wrapper.Dimensions;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.collection.Containers;

final class MovingFeatureBuilder
extends MovingFeatures {
    private final Period[] properties;
    private final int[] count;
    private long tmin = Long.MAX_VALUE;
    private long tmax = Long.MIN_VALUE;

    public MovingFeatureBuilder(MovingFeatureBuilder share, int numProperties) {
        super((MovingFeatures)share);
        this.properties = new Period[numProperties];
        this.count = new int[numProperties];
    }

    public final void addTimeRange(long startTime, long endTime) {
        if (startTime < this.tmin) {
            this.tmin = startTime;
        }
        if (endTime > this.tmax) {
            this.tmax = endTime;
        }
    }

    public final void addValue(int index, long startTime, long endTime, Object value) {
        Period p = this.properties[index];
        if (p != null && p.endTime == startTime && Objects.equals(p.value, value)) {
            p.endTime = endTime;
        } else {
            this.properties[index] = new Period(p, startTime, endTime, value);
            int n = index;
            this.count[n] = this.count[n] + 1;
        }
    }

    public final void storeTimeRange(String startTime, String endTime, AbstractFeature dest) {
        if (this.tmin < this.tmax) {
            Instant t = Instant.ofEpochMilli(this.tmin);
            dest.setPropertyValue(startTime, (Object)t);
            dest.setPropertyValue(endTime, (Object)(this.tmin == this.tmax ? t : Instant.ofEpochMilli(this.tmax)));
        }
    }

    public final <V> void storeAttribute(int index, AbstractAttribute<V> dest) {
        int n = this.count[index];
        long[] times = new long[n];
        Object[] values = (Object[])Array.newInstance(dest.getType().getValueClass(), n);
        Period p = this.properties[index];
        while (p != null) {
            times[--n] = p.startTime;
            values[n] = p.value;
            p = p.previous;
        }
        if (n != 0) {
            throw new CorruptedObjectException();
        }
        dest.setValues((Collection)Containers.viewAsUnmodifiableList((Object[])values));
        this.setInstants(dest, times);
    }

    public final <G> void storeGeometry(String featureName, int index, int dimension, Geometries<G> factory, AbstractAttribute<G> dest, Consumer<LogRecord> warningListener) {
        int i;
        int n = this.count[index];
        Vector[] vectors = new Vector[n];
        Period p = this.properties[index];
        while (p != null) {
            vectors[--n] = Vector.create((Object)p.value, (boolean)false);
            p = p.previous;
        }
        if (n != 0) {
            throw new CorruptedObjectException();
        }
        int warnings = 10;
        int numPts = 0;
        Vector previous = null;
        for (i = 0; i < vectors.length; ++i) {
            int length;
            Vector v = vectors[i];
            if (v == null || (length = v.size()) == 0) continue;
            if (length % dimension != 0) {
                if (--warnings < 0) continue;
                Period p2 = this.properties[index];
                int j = i;
                while (--j >= 0) {
                    p2 = p2.previous;
                }
                warningListener.accept(Resources.forLocale(null).createLogRecord(Level.WARNING, (short)58, featureName, new Date(p2.startTime), dimension, length));
                continue;
            }
            if (previous != null && MovingFeatureBuilder.equals(previous, v, dimension)) {
                v = v.subList(dimension, length);
                if ((length -= dimension) == 0) {
                    vectors[i] = null;
                    continue;
                }
                vectors[i] = v;
            }
            numPts += length;
            previous = v;
        }
        i = vectors.length;
        long[] times = new long[numPts /= dimension];
        Period p3 = this.properties[index];
        while (p3 != null) {
            Vector v;
            if ((v = vectors[--i]) != null) {
                int c = v.size() / dimension;
                if (c == 1) {
                    times[--numPts] = p3.endTime;
                } else {
                    long startTime = p3.startTime;
                    double scale = (double)(p3.endTime - startTime) / (double)(c - 1);
                    while (--c >= 0) {
                        times[--numPts] = startTime + Math.round(scale * (double)c);
                    }
                }
            }
            p3 = p3.previous;
        }
        if (numPts != 0) {
            throw new CorruptedObjectException();
        }
        dest.setValue(factory.createPolyline(false, Dimensions.forCount((int)dimension, (boolean)false), vectors));
        this.setInstants(dest, times);
    }

    private static boolean equals(Vector previous, Vector next, int dimension) {
        int p = previous.size();
        while (--dimension >= 0) {
            if (next.doubleValue(dimension) == previous.doubleValue(--p)) continue;
            return false;
        }
        return true;
    }

    private static final class Period {
        final long startTime;
        long endTime;
        final Object value;
        final Period previous;

        Period(Period previous, long startTime, long endTime, Object value) {
            this.previous = previous;
            this.startTime = startTime;
            this.endTime = endTime;
            this.value = value;
        }
    }
}

