/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.internal.shared;

import java.awt.Rectangle;
import org.apache.sis.io.TableAppender;

public final class AssertionMessages {
    private AssertionMessages() {
    }

    public static String notContained(Rectangle outer, Rectangle inner) {
        StringBuilder message = new StringBuilder();
        if (outer.intersects(inner)) {
            if (inner.width > outer.width || inner.height > outer.height) {
                message.append("Subset is larger than the bounds. ");
            } else if (inner.x < outer.x || inner.y < outer.y) {
                message.append("Subset starts before the bounds. ");
            } else {
                message.append("Subset finishes after the bounds. ");
            }
        } else {
            message.append("Subset is fully outside the bounds. ");
        }
        message.append("Rectangles are:").append(System.lineSeparator());
        TableAppender table = new TableAppender(" ");
        AssertionMessages.append(table, "outer", outer);
        AssertionMessages.append(table, "inner", inner);
        return message.append(table).toString();
    }

    private static void append(TableAppender table, String header, Rectangle bounds) {
        table.append((CharSequence)header).append(':').nextColumn();
        int i = 0;
        while (true) {
            int v;
            char c;
            switch (i) {
                case 0: {
                    c = 'x';
                    v = bounds.x;
                    break;
                }
                case 1: {
                    c = 'y';
                    v = bounds.y;
                    break;
                }
                case 2: {
                    c = 'w';
                    v = bounds.width;
                    break;
                }
                case 3: {
                    c = 'h';
                    v = bounds.height;
                    break;
                }
                default: {
                    table.nextLine();
                    return;
                }
            }
            table.append(c).append('=').nextColumn();
            table.setCellAlignment((byte)1);
            table.append((CharSequence)Integer.toString(v)).nextColumn();
            table.setCellAlignment((byte)-1);
            ++i;
        }
    }
}

