/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.sling.xss.impl.FallbackSlingPolicy;
import org.apache.sling.xss.impl.HtmlSanitizer;
import org.apache.sling.xss.impl.xml.AntiSamyPolicy;

public class PolicyHandler {
    private final AntiSamyPolicy policy;
    private AntiSamyPolicy fallbackPolicy;
    private HtmlSanitizer htmlSanitizer;
    private HtmlSanitizer fallbackHtmlSanitizer;

    public PolicyHandler(InputStream policyStream) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)policyStream, (OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            this.policy = new AntiSamyPolicy(bais);
            bais.reset();
            this.htmlSanitizer = new HtmlSanitizer(this.policy);
            this.fallbackPolicy = new FallbackSlingPolicy(bais);
            this.fallbackHtmlSanitizer = new HtmlSanitizer(this.fallbackPolicy);
        }
    }

    public AntiSamyPolicy getPolicy() {
        return this.policy;
    }

    public HtmlSanitizer getHtmlSanitizer() {
        return this.htmlSanitizer;
    }

    public HtmlSanitizer getFallbackHtmlSanitizer() {
        return this.fallbackHtmlSanitizer;
    }
}

