/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.activation.DataSource;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.cfg.mail.MailServerInfo;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.content.api.ContentItem;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MailActivityBehavior.class);
    private static final String NEWLINE_REGEX = "\\r?\\n";
    protected Expression to;
    protected Expression from;
    protected Expression cc;
    protected Expression bcc;
    protected Expression headers;
    protected Expression subject;
    protected Expression text;
    protected Expression textVar;
    protected Expression html;
    protected Expression htmlVar;
    protected Expression charset;
    protected Expression ignoreException;
    protected Expression exceptionVariableName;
    protected Expression attachments;

    @Override
    public void execute(DelegateExecution execution) {
        FlowElement flowElement = execution.getCurrentFlowElement();
        boolean isSkipExpressionEnabled = false;
        String skipExpressionText = null;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        if (flowElement instanceof ServiceTask) {
            ServiceTask serviceTask = (ServiceTask)flowElement;
            skipExpressionText = serviceTask.getSkipExpression();
            isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(skipExpressionText, flowElement.getId(), execution, commandContext);
        }
        if (!isSkipExpressionEnabled || !SkipExpressionUtil.shouldSkipFlowElement(skipExpressionText, flowElement.getId(), execution, commandContext)) {
            boolean doIgnoreException = Boolean.parseBoolean(this.getStringFromField(this.ignoreException, execution));
            String exceptionVariable = this.getStringFromField(this.exceptionVariableName, execution);
            Email email = null;
            try {
                String headersStr = this.getStringFromField(this.headers, execution);
                Collection<String> toList = this.parseRecipients(this.to, execution);
                String fromStr = this.getStringFromField(this.from, execution);
                Collection<String> ccList = this.parseRecipients(this.cc, execution);
                Collection<String> bccList = this.parseRecipients(this.bcc, execution);
                String subjectStr = this.getStringFromField(this.subject, execution);
                String textStr = this.textVar == null ? this.getStringFromField(this.text, execution) : this.getStringFromField(this.getExpression(execution, this.textVar), execution);
                String htmlStr = this.htmlVar == null ? this.getStringFromField(this.html, execution) : this.getStringFromField(this.getExpression(execution, this.htmlVar), execution);
                String charSetStr = this.getStringFromField(this.charset, execution);
                LinkedList<File> files = new LinkedList<File>();
                LinkedList<DataSource> dataSources = new LinkedList<DataSource>();
                this.getFilesFromFields(this.attachments, execution, files, dataSources);
                if (toList.isEmpty() && ccList.isEmpty() && bccList.isEmpty()) {
                    throw new FlowableException("No recipient could be found for sending email");
                }
                email = this.createEmail(textStr, htmlStr, this.attachmentsExist(files, dataSources));
                this.addHeader(email, headersStr);
                this.addTo(email, toList, execution.getTenantId());
                this.setFrom(email, fromStr, execution.getTenantId());
                this.addCc(email, ccList, execution.getTenantId());
                this.addBcc(email, bccList, execution.getTenantId());
                this.setSubject(email, subjectStr);
                this.setMailServerProperties(email, execution.getTenantId());
                this.setCharset(email, charSetStr, execution.getTenantId());
                this.attach(email, files, dataSources);
                email.send();
            }
            catch (FlowableException e) {
                this.handleException(execution, e.getMessage(), (Exception)((Object)e), doIgnoreException, exceptionVariable);
            }
            catch (EmailException e) {
                this.handleException(execution, "Could not send e-mail in execution " + execution.getId(), (Exception)((Object)e), doIgnoreException, exceptionVariable);
            }
        }
        this.leave(execution);
    }

    protected void addHeader(Email email, String headersStr) {
        if (headersStr == null) {
            return;
        }
        for (String headerEntry : headersStr.split(NEWLINE_REGEX)) {
            String[] split = headerEntry.split(":");
            if (split.length != 2) {
                throw new FlowableIllegalArgumentException("When using email headers name and value must be defined colon separated. (e.g. X-Attribute: value");
            }
            String name = split[0].trim();
            String value = split[1].trim();
            email.addHeader(name, value);
        }
    }

    private boolean attachmentsExist(List<File> files, List<DataSource> dataSources) {
        return files != null && !files.isEmpty() || dataSources != null && !dataSources.isEmpty();
    }

    protected Email createEmail(String text, String html, boolean attachmentsExist) {
        if (html != null) {
            return this.createHtmlEmail(text, html);
        }
        if (text != null) {
            if (!attachmentsExist) {
                return this.createTextOnlyEmail(text);
            }
            return this.createMultiPartEmail(text);
        }
        throw new FlowableIllegalArgumentException("'html' or 'text' is required to be defined when using the mail activity");
    }

    protected HtmlEmail createHtmlEmail(String text, String html) {
        HtmlEmail email = new HtmlEmail();
        try {
            email.setHtmlMsg(html);
            if (text != null) {
                email.setTextMsg(text);
            }
            return email;
        }
        catch (EmailException e) {
            throw new FlowableException("Could not create HTML email", (Throwable)e);
        }
    }

    protected SimpleEmail createTextOnlyEmail(String text) {
        SimpleEmail email = new SimpleEmail();
        try {
            email.setMsg(text);
            return email;
        }
        catch (EmailException e) {
            throw new FlowableException("Could not create text-only email", (Throwable)e);
        }
    }

    protected MultiPartEmail createMultiPartEmail(String text) {
        MultiPartEmail email = new MultiPartEmail();
        try {
            email.setMsg(text);
            return email;
        }
        catch (EmailException e) {
            throw new FlowableException("Could not create text-only email", (Throwable)e);
        }
    }

    protected void addTo(Email email, Collection<String> to, String tenantId) {
        if (to == null || to.isEmpty()) {
            return;
        }
        Collection<String> newTo = to;
        Collection<String> forceTo = this.getForceTo(tenantId);
        if (forceTo != null && !forceTo.isEmpty()) {
            newTo = forceTo;
        }
        if (!newTo.isEmpty()) {
            for (String t : newTo) {
                try {
                    email.addTo(t);
                }
                catch (EmailException e) {
                    throw new FlowableException("Could not add " + t + " as recipient", (Throwable)e);
                }
            }
        } else {
            throw new FlowableException("No recipient could be found for sending email");
        }
    }

    protected void setFrom(Email email, String from, String tenantId) {
        String fromAddress = null;
        if (from != null) {
            fromAddress = from;
        } else {
            Map<String, MailServerInfo> mailServers;
            if (tenantId != null && tenantId.length() > 0 && (mailServers = CommandContextUtil.getProcessEngineConfiguration().getMailServers()) != null && mailServers.containsKey(tenantId)) {
                MailServerInfo mailServerInfo = mailServers.get(tenantId);
                fromAddress = mailServerInfo.getMailServerDefaultFrom();
            }
            if (fromAddress == null) {
                fromAddress = CommandContextUtil.getProcessEngineConfiguration().getMailServerDefaultFrom();
            }
        }
        try {
            email.setFrom(fromAddress);
        }
        catch (EmailException e) {
            throw new FlowableException("Could not set " + from + " as from address in email", (Throwable)e);
        }
    }

    protected void addCc(Email email, Collection<String> cc, String tenantId) {
        if (cc == null || cc.isEmpty()) {
            return;
        }
        Collection<String> newCc = cc;
        Collection<String> forceTo = this.getForceTo(tenantId);
        if (forceTo != null && !forceTo.isEmpty()) {
            newCc = forceTo;
        }
        if (!newCc.isEmpty()) {
            for (String c : newCc) {
                try {
                    email.addCc(c);
                }
                catch (EmailException e) {
                    throw new FlowableException("Could not add " + c + " as cc recipient", (Throwable)e);
                }
            }
        }
    }

    protected void addBcc(Email email, Collection<String> bcc, String tenantId) {
        if (bcc == null || bcc.isEmpty()) {
            return;
        }
        Collection<String> newBcc = bcc;
        Collection<String> forceTo = this.getForceTo(tenantId);
        if (forceTo != null && !forceTo.isEmpty()) {
            newBcc = forceTo;
        }
        if (!newBcc.isEmpty()) {
            for (String b : newBcc) {
                try {
                    email.addBcc(b);
                }
                catch (EmailException e) {
                    throw new FlowableException("Could not add " + b + " as bcc recipient", (Throwable)e);
                }
            }
        }
    }

    protected void attach(Email email, List<File> files, List<DataSource> dataSources) throws EmailException {
        if (!(email instanceof MultiPartEmail) || !this.attachmentsExist(files, dataSources)) {
            return;
        }
        MultiPartEmail mpEmail = (MultiPartEmail)email;
        for (File file : files) {
            mpEmail.attach(file);
        }
        for (DataSource ds : dataSources) {
            if (ds == null) continue;
            mpEmail.attach(ds, ds.getName(), null);
        }
    }

    protected void setSubject(Email email, String subject) {
        email.setSubject(subject != null ? subject : "");
    }

    protected void setMailServerProperties(Email email, String tenantId) {
        String host;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        boolean isMailServerSet = false;
        if (tenantId != null && tenantId.length() > 0) {
            if (processEngineConfiguration.getMailSessionJndi(tenantId) != null) {
                this.setEmailSession(email, processEngineConfiguration.getMailSessionJndi(tenantId));
                isMailServerSet = true;
            } else if (processEngineConfiguration.getMailServer(tenantId) != null) {
                MailServerInfo mailServerInfo = processEngineConfiguration.getMailServer(tenantId);
                host = mailServerInfo.getMailServerHost();
                if (host == null) {
                    throw new FlowableException("Could not send email: no SMTP host is configured for tenantId " + tenantId);
                }
                email.setHostName(host);
                email.setSmtpPort(mailServerInfo.getMailServerPort());
                email.setSslSmtpPort(Integer.toString(mailServerInfo.getMailServerSSLPort()));
                email.setSSLOnConnect(mailServerInfo.isMailServerUseSSL());
                email.setStartTLSEnabled(mailServerInfo.isMailServerUseTLS());
                String user = mailServerInfo.getMailServerUsername();
                String password = mailServerInfo.getMailServerPassword();
                if (user != null && password != null) {
                    email.setAuthentication(user, password);
                }
                isMailServerSet = true;
            }
        }
        if (!isMailServerSet) {
            String mailSessionJndi = processEngineConfiguration.getMailSessionJndi();
            if (mailSessionJndi != null) {
                this.setEmailSession(email, mailSessionJndi);
            } else {
                host = processEngineConfiguration.getMailServerHost();
                if (host == null) {
                    throw new FlowableException("Could not send email: no SMTP host is configured");
                }
                email.setHostName(host);
                int port = processEngineConfiguration.getMailServerPort();
                email.setSmtpPort(port);
                email.setSslSmtpPort(Integer.toString(processEngineConfiguration.getMailServerSSLPort()));
                email.setSSLOnConnect(processEngineConfiguration.getMailServerUseSSL());
                email.setStartTLSEnabled(processEngineConfiguration.getMailServerUseTLS());
                String user = processEngineConfiguration.getMailServerUsername();
                String password = processEngineConfiguration.getMailServerPassword();
                if (user != null && password != null) {
                    email.setAuthentication(user, password);
                }
            }
        }
    }

    protected void setEmailSession(Email email, String mailSessionJndi) {
        try {
            email.setMailSessionFromJNDI(mailSessionJndi);
        }
        catch (NamingException e) {
            throw new FlowableException("Could not send email: Incorrect JNDI configuration", (Throwable)e);
        }
    }

    protected void setCharset(Email email, String charSetStr, String tenantId) {
        if (this.charset != null) {
            email.setCharset(charSetStr);
        } else {
            Charset mailServerDefaultCharset = this.getDefaultCharSet(tenantId);
            if (mailServerDefaultCharset != null) {
                email.setCharset(mailServerDefaultCharset.name());
            }
        }
    }

    protected Collection<String> splitAndTrim(String str) {
        if (str != null) {
            return Arrays.stream(str.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return null;
    }

    protected String getStringFromField(Expression expression, DelegateExecution execution) {
        Object value;
        if (expression != null && (value = expression.getValue((VariableContainer)execution)) != null) {
            return value.toString();
        }
        return null;
    }

    protected Collection<String> parseRecipients(Expression expression, DelegateExecution execution) {
        if (expression == null) {
            return Collections.emptyList();
        }
        Object value = expression.getValue((VariableContainer)execution);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)value;
            ArrayList<String> recipients = new ArrayList<String>(arrayNode.size());
            for (JsonNode node : arrayNode) {
                recipients.add(node.asText());
            }
            return recipients;
        }
        String str = value.toString();
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return Arrays.asList(value.toString().split("[\\s]*,[\\s]*"));
        }
        return Collections.emptyList();
    }

    protected void getFilesFromFields(Expression expression, DelegateExecution execution, List<File> files, List<DataSource> dataSources) {
        if (expression == null) {
            return;
        }
        Object value = expression.getValue((VariableContainer)execution);
        if (value != null) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (!collection.isEmpty()) {
                    for (Object object : collection) {
                        this.addExpressionValueToAttachments(object, files, dataSources);
                    }
                }
            } else {
                this.addExpressionValueToAttachments(value, files, dataSources);
            }
            files.removeIf(file -> !this.fileExists((File)file));
        }
    }

    protected void addExpressionValueToAttachments(Object value, List<File> files, List<DataSource> dataSources) {
        if (value instanceof File) {
            files.add((File)value);
        } else if (value instanceof String) {
            files.add(new File((String)value));
        } else if (value instanceof File[]) {
            Collections.addAll(files, (File[])value);
        } else if (value instanceof String[]) {
            String[] paths;
            for (String path : paths = (String[])value) {
                files.add(new File(path));
            }
        } else if (value instanceof DataSource) {
            dataSources.add((DataSource)value);
        } else if (value instanceof DataSource[]) {
            for (DataSource ds : (DataSource[])value) {
                if (ds == null) continue;
                dataSources.add(ds);
            }
        } else if (value instanceof ContentItem) {
            dataSources.add(new ContentItemDataSourceWrapper((ContentItem)value));
        } else if (value instanceof ContentItem[]) {
            for (ContentItem contentItem : (ContentItem[])value) {
                dataSources.add(new ContentItemDataSourceWrapper(contentItem));
            }
        } else {
            throw new FlowableException("Invalid attachment type: " + value.getClass());
        }
    }

    protected boolean fileExists(File file) {
        return file != null && file.exists() && file.isFile() && file.canRead();
    }

    protected Expression getExpression(DelegateExecution execution, Expression var) {
        String variable = (String)execution.getVariable(var.getExpressionText());
        return CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(variable);
    }

    protected void handleException(DelegateExecution execution, String msg, Exception e, boolean doIgnoreException, String exceptionVariable) {
        if (doIgnoreException) {
            LOGGER.info("Ignoring email send error: {}", (Object)msg, (Object)e);
            if (exceptionVariable != null && exceptionVariable.length() > 0) {
                execution.setVariable(exceptionVariable, msg);
            }
        } else {
            if (e instanceof FlowableException) {
                throw (FlowableException)((Object)e);
            }
            throw new FlowableException(msg, (Throwable)e);
        }
    }

    protected Collection<String> getForceTo(String tenantId) {
        Map<String, MailServerInfo> mailServers;
        String forceTo = null;
        if (tenantId != null && tenantId.length() > 0 && (mailServers = CommandContextUtil.getProcessEngineConfiguration().getMailServers()) != null && mailServers.containsKey(tenantId)) {
            MailServerInfo mailServerInfo = mailServers.get(tenantId);
            forceTo = mailServerInfo.getMailServerForceTo();
        }
        if (forceTo == null) {
            forceTo = CommandContextUtil.getProcessEngineConfiguration().getMailServerForceTo();
        }
        return this.splitAndTrim(forceTo);
    }

    protected Charset getDefaultCharSet(String tenantId) {
        MailServerInfo mailServerInfo;
        Charset defaultCharset = null;
        if (StringUtils.isNotBlank((CharSequence)tenantId) && (mailServerInfo = CommandContextUtil.getProcessEngineConfiguration().getMailServer(tenantId)) != null) {
            defaultCharset = mailServerInfo.getMailServerDefaultCharset();
        }
        if (defaultCharset == null) {
            defaultCharset = CommandContextUtil.getProcessEngineConfiguration().getMailServerDefaultCharset();
        }
        return defaultCharset;
    }

    public static class ContentItemDataSourceWrapper
    implements DataSource {
        protected ContentItem contentItem;

        public ContentItemDataSourceWrapper(ContentItem contentItem) {
            this.contentItem = contentItem;
        }

        public InputStream getInputStream() throws IOException {
            return CommandContextUtil.getContentService().getContentItemData(this.contentItem.getId());
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getContentType() {
            return this.contentItem.getMimeType();
        }

        public String getName() {
            return this.contentItem.getName();
        }
    }
}

