/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Collection;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class RemoveTaskVariablesCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    private final Collection<String> variableNames;
    private final boolean isLocal;

    public RemoveTaskVariablesCmd(String taskId, Collection<String> variableNames, boolean isLocal) {
        super(taskId);
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (task.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.removeTaskVariables(this.taskId, this.variableNames, this.isLocal);
            return null;
        }
        if (this.isLocal) {
            task.removeVariablesLocal(this.variableNames);
        } else {
            task.removeVariables(this.variableNames);
        }
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot remove variables from a suspended task.";
    }
}

