/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import org.apereo.cas.ticket.expiration.AbstractCasExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class OAuth20RefreshTokenExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = -7144233906843566234L;
    private long timeToKillInSeconds;

    @JsonCreator
    public OAuth20RefreshTokenExpirationPolicy(@JsonProperty(value="timeToLive") long timeToKillInSeconds) {
        this.timeToKillInSeconds = timeToKillInSeconds;
    }

    public boolean isExpired(TicketGrantingTicketAwareTicket ticketState) {
        boolean expired = this.isRefreshTokenExpired((Ticket)ticketState);
        return expired || super.isExpired(ticketState);
    }

    public Long getTimeToLive() {
        return this.timeToKillInSeconds;
    }

    @JsonIgnore
    public Long getTimeToIdle() {
        return 0L;
    }

    @JsonIgnore
    protected boolean isRefreshTokenExpired(Ticket ticketState) {
        if (ticketState == null) {
            return true;
        }
        ZonedDateTime expiringTime = ticketState.getCreationTime().plus(this.timeToKillInSeconds, ChronoUnit.SECONDS);
        return expiringTime.isBefore(ZonedDateTime.now(ZoneOffset.UTC));
    }

    @Generated
    public OAuth20RefreshTokenExpirationPolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth20RefreshTokenExpirationPolicy)) {
            return false;
        }
        OAuth20RefreshTokenExpirationPolicy other = (OAuth20RefreshTokenExpirationPolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.timeToKillInSeconds == other.timeToKillInSeconds;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuth20RefreshTokenExpirationPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $timeToKillInSeconds = this.timeToKillInSeconds;
        result = result * 59 + (int)($timeToKillInSeconds >>> 32 ^ $timeToKillInSeconds);
        return result;
    }

    @Generated
    public String toString() {
        return "OAuth20RefreshTokenExpirationPolicy(super=" + super.toString() + ", timeToKillInSeconds=" + this.timeToKillInSeconds + ")";
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    public static class OAuthRefreshTokenStandaloneExpirationPolicy
    extends OAuth20RefreshTokenExpirationPolicy {
        private static final long serialVersionUID = -7768661082888351104L;

        @JsonCreator
        public OAuthRefreshTokenStandaloneExpirationPolicy(@JsonProperty(value="timeToLive") long timeToKillInSeconds) {
            super(timeToKillInSeconds);
        }

        @Override
        public boolean isExpired(TicketGrantingTicketAwareTicket ticketState) {
            return this.isRefreshTokenExpired((Ticket)ticketState);
        }

        @Generated
        public OAuthRefreshTokenStandaloneExpirationPolicy() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuthRefreshTokenStandaloneExpirationPolicy)) {
                return false;
            }
            OAuthRefreshTokenStandaloneExpirationPolicy other = (OAuthRefreshTokenStandaloneExpirationPolicy)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OAuthRefreshTokenStandaloneExpirationPolicy;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "OAuth20RefreshTokenExpirationPolicy.OAuthRefreshTokenStandaloneExpirationPolicy(super=" + super.toString() + ")";
        }
    }
}

