/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class TransformVersion {
    static final TransformVersion ISO19139 = new TransformVersion(42, 2);
    static final TransformVersion GML31;
    static final TransformVersion ALL;
    private final Map<String, String> exports;
    private final Map<String, String> imports;

    private TransformVersion(int ec, int ic) {
        this.exports = new HashMap<String, String>(ec);
        this.imports = new HashMap<String, String>(ic);
    }

    private TransformVersion(TransformVersion first) {
        this.exports = new HashMap<String, String>(first.exports);
        this.imports = new HashMap<String, String>(first.imports);
    }

    private void addAlias(String standard, String alias) {
        this.imports.put(alias, standard);
    }

    private void addBijective(String jaxb, String xml) {
        this.exports.put(jaxb, xml);
        this.imports.put(xml, jaxb);
    }

    private void addSurjective(String jaxb, String xml) {
        this.exports.put(jaxb, xml);
    }

    private void addSurjectives(String[] jaxb, String xml) {
        for (String e : jaxb) {
            this.exports.put(e, xml);
        }
    }

    final String exportNS(String uri) {
        return this.exports.getOrDefault(uri, uri);
    }

    final String importNS(String uri) {
        return this.imports.getOrDefault(uri, uri);
    }

    final Iterator<Map.Entry<String, String>> exports() {
        return this.exports.entrySet().iterator();
    }

    static {
        ISO19139.addSurjectives(new String[]{"http://standards.iso.org/iso/19115/-3/cat/1.0", "http://standards.iso.org/iso/19115/-3/cit/1.0", "http://standards.iso.org/iso/19157/-2/dqc/1.0", "http://standards.iso.org/iso/19110/fcc/1.0", "http://standards.iso.org/iso/19115/-3/gex/1.0", "http://standards.iso.org/iso/19115/-3/gmw/1.0", "http://standards.iso.org/iso/19115/-3/lan/1.0", "http://standards.iso.org/iso/19115/-3/mac/1.0", "http://standards.iso.org/iso/19115/-3/mas/1.0", "http://standards.iso.org/iso/19115/-3/mcc/1.0", "http://standards.iso.org/iso/19115/-3/mco/1.0", "http://standards.iso.org/iso/19115/-3/md1/1.0", "http://standards.iso.org/iso/19115/-3/md2/1.0", "http://standards.iso.org/iso/19115/-3/mda/1.0", "http://standards.iso.org/iso/19115/-3/mdb/1.0", "http://standards.iso.org/iso/19157/-2/mdq/1.0", "http://standards.iso.org/iso/19115/-3/mds/1.0", "http://standards.iso.org/iso/19115/-3/mdt/1.0", "http://standards.iso.org/iso/19115/-3/mex/1.0", "http://standards.iso.org/iso/19115/-3/mmi/1.0", "http://standards.iso.org/iso/19115/-3/mpc/1.0", "http://standards.iso.org/iso/19115/-3/mrc/1.0", "http://standards.iso.org/iso/19115/-3/mrd/1.0", "http://standards.iso.org/iso/19115/-3/mri/1.0", "http://standards.iso.org/iso/19115/-3/mrl/1.0", "http://standards.iso.org/iso/19115/-3/mrs/1.0", "http://standards.iso.org/iso/19115/-3/msr/1.0", "http://standards.iso.org/iso/19111/rce/1.0"}, "http://www.isotc211.org/2005/gmd");
        ISO19139.addSurjective("http://standards.iso.org/iso/19115/-3/srv/2.0", "http://www.isotc211.org/2005/srv");
        ISO19139.addSurjective("http://standards.iso.org/iso/19115/-3/gcx/1.0", "http://www.isotc211.org/2005/gmx");
        ISO19139.addBijective("http://standards.iso.org/iso/19115/-3/gco/1.0", "http://www.isotc211.org/2005/gco");
        ISO19139.addAlias("http://standards.iso.org/iso/19115/-2/gmi/1.0", "http://www.isotc211.org/2005/gmi");
        GML31 = new TransformVersion(ISO19139);
        GML31.addBijective("http://www.opengis.net/gml/3.2", "http://www.opengis.net/gml");
        ALL = GML31;
    }
}

