/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.catalina.tribes;

/**
 * The listener to be registered with the ChannelReceiver, internal Tribes component.
 */
public interface MessageListener {

    /**
     * Receive a message from the IO components in the Channel stack
     *
     * @param msg the message
     */
    void messageReceived(ChannelMessage msg);

    /**
     * Allows skipping processing of the specified message.
     *
     * @param msg the message
     *
     * @return {@code true} if the message will be processed
     */
    boolean accept(ChannelMessage msg);
}
