/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openejb.client.Client;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionManager;
import org.apache.openejb.client.ConnectionStrategy;
import org.apache.openejb.client.Context;
import org.apache.openejb.client.RemoteFailoverException;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.event.BootstrappingConnection;
import org.apache.openejb.client.event.FailoverSelection;

public abstract class AbstractConnectionStrategy
implements ConnectionStrategy {
    private final ReentrantLock lock = new ReentrantLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(ClusterMetaData cluster, ServerMetaData server) throws IOException {
        URI uri;
        ReentrantLock l;
        block9: {
            l = this.lock;
            l.lock();
            Set<URI> failed = Client.getFailed();
            HashSet<URI> remaining = new HashSet<URI>();
            boolean failover = false;
            Iterable<URI> iterable = this.getIterable(cluster);
            for (URI uri2 : iterable) {
                if (failed.contains(uri2)) continue;
                if (failover) {
                    Client.fireEvent(this.createFailureEvent(remaining, failed, uri2));
                }
                try {
                    Connection connection = this.connect(cluster, uri2);
                    return connection;
                }
                catch (IOException e) {
                    if (!failover) {
                        Collections.addAll(remaining, cluster.getLocations());
                        remaining.removeAll(failed);
                    }
                    failed.add(uri2);
                    remaining.remove(uri2);
                    failover = true;
                }
            }
            uri = server.getLocation();
            if (uri != null) break block9;
            throw new RemoteFailoverException("Attempted to connect to " + failed.size() + " servers.");
        }
        Client.fireEvent(new BootstrappingConnection(uri));
        Connection connection = this.connect(cluster, uri);
        return connection;
        finally {
            l.unlock();
        }
    }

    private Iterable<URI> getIterable(ClusterMetaData cluster) {
        Context context = cluster.getContext();
        StrategyData data = context.getComponent(StrategyData.class);
        if (data != null) {
            return data.getIterable();
        }
        context.setComponent(StrategyData.class, new StrategyData(this.createIterable(cluster)));
        return this.getIterable(cluster);
    }

    protected abstract FailoverSelection createFailureEvent(Set<URI> var1, Set<URI> var2, URI var3);

    protected abstract Iterable<URI> createIterable(ClusterMetaData var1);

    protected Connection connect(ClusterMetaData cluster, URI uri) throws IOException {
        Connection connection = ConnectionManager.getConnection(uri);
        cluster.setLastLocation(connection.getURI());
        return connection;
    }

    private static class StrategyData {
        private final Iterable<URI> iterable;

        private StrategyData(Iterable<URI> iterable) {
            this.iterable = iterable;
        }

        public Iterable<URI> getIterable() {
            return this.iterable;
        }
    }
}

