/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.container;

import java.io.File;
import java.io.InputStream;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.fulcrum.yaafi.container.Container;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerConfiguration;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerFactory;

public class ContainerImpl
extends AbstractLogEnabled
implements Container,
Initializable,
Disposable {
    protected ServiceContainerConfiguration config;
    protected ServiceContainer manager;
    protected int logLevel = 1;

    public ContainerImpl(Logger logger) {
        this.enableLogging(logger);
        this.config = new ServiceContainerConfiguration(this.logLevel);
    }

    public ContainerImpl() {
        this.enableLogging((Logger)new ConsoleLogger(this.logLevel));
        this.config = new ServiceContainerConfiguration(this.logLevel);
    }

    @Override
    public void startup(String configFileName, String roleFileName, String parametersFileName) {
        InputStream configIO;
        this.getLogger().debug("Starting container...");
        this.config.setComponentConfigurationLocation(configFileName);
        this.config.setComponentRolesLocation(roleFileName);
        this.config.setParametersLocation(parametersFileName);
        this.config.setLogger(this.getLogger());
        File configFile = new File(configFileName);
        if (!configFile.exists() && (configIO = this.getClass().getResourceAsStream(configFileName)) == null) {
            throw new RuntimeException("Could not initialize the container because the config file could not be found:" + configFileName);
        }
        try {
            this.initialize();
            this.getLogger().info("YaffiContainer ready.");
        }
        catch (Exception e) {
            this.getLogger().error("Could not initialize the container", (Throwable)e);
            throw new RuntimeException("Could not initialize the container");
        }
    }

    public void initialize() throws Exception {
        this.manager = ServiceContainerFactory.create(this.config);
    }

    public void dispose() {
        this.getLogger().debug("Disposing of container...");
        this.manager.dispose();
        this.getLogger().info("YaffiContainer has been disposed.");
    }

    @Override
    public Object lookup(String roleName) throws ComponentException {
        try {
            return this.manager.lookup(roleName);
        }
        catch (Exception e) {
            String msg = "Failed to lookup role " + roleName;
            throw new ComponentException(roleName, msg, (Throwable)e);
        }
    }

    public void release(Component component) {
        this.manager.release(component);
    }

    @Override
    public void release(Object component) {
        this.manager.release(component);
    }

    public void decommission(String name) throws ServiceException {
        if (this.manager != null) {
            this.manager.decommission(name);
        }
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }
}

