/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import org.apache.uima.caseditor.editor.ICustomInformationControlContentHandler;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CustomInformationControl
implements IInformationControl,
IInformationControlExtension2 {
    private Shell mShell;
    private Control mControl;
    private ICustomInformationControlContentHandler mContentHandler;

    public CustomInformationControl(Shell parent, ICustomInformationControlContentHandler contentHandler) {
        this.mContentHandler = contentHandler;
        this.mShell = new Shell(parent, 540672);
        this.mShell.setLayout((Layout)new FillLayout());
        Display display = this.mShell.getDisplay();
        this.mShell.setBackground(display.getSystemColor(2));
    }

    public void setControl(Control viewerControl) {
        this.mControl = viewerControl;
        this.mShell.setSize(viewerControl.getSize());
    }

    public Composite getParent() {
        return this.mShell;
    }

    public void setInformation(String information) {
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.mShell.computeSize(-1, -1);
    }

    public void setVisible(boolean visible) {
        this.mControl.setVisible(visible);
        this.mShell.setVisible(visible);
    }

    public void setSize(int width, int height) {
    }

    public void setLocation(Point location) {
        Rectangle trim = this.mShell.computeTrim(0, 0, 0, 0);
        Point textLocation = this.mControl.getLocation();
        location.x += trim.x - textLocation.x;
        location.y += trim.y - textLocation.y;
        this.mShell.setLocation(location);
    }

    public void dispose() {
        if (this.mShell != null && !this.mShell.isDisposed()) {
            this.mShell.dispose();
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        this.mShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.mShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.mShell.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.mShell.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.mShell.isFocusControl();
    }

    public void setFocus() {
        this.mShell.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.mShell.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.mShell.removeFocusListener(listener);
    }

    public void setInput(Object input) {
        this.mContentHandler.setInput(this, input);
    }

    public Control getControl() {
        return this.mControl;
    }
}

