/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.MultiException;
import org.osgi.framework.Bundle;

@Command(scope="bundle", name="restart", description="Restarts bundles.")
@Service
public class Restart
extends BundlesCommand {
    public Restart() {
        this.defaultAllBundles = false;
        this.errorMessage = "Error restarting bundle";
    }

    @Override
    protected Object doExecute(List<Bundle> bundles) throws Exception {
        if (bundles.isEmpty()) {
            System.err.println("No bundles specified.");
            return null;
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Bundle bundle : bundles) {
            try {
                bundle.stop(1);
            }
            catch (Exception e) {
                exceptions.add(new Exception("Unable to stop bundle " + bundle.getBundleId() + ": " + e.getMessage(), e));
            }
        }
        for (Bundle bundle : bundles) {
            try {
                bundle.start(1);
            }
            catch (Exception e) {
                exceptions.add(new Exception("Unable to start bundle " + bundle.getBundleId() + ": " + e.getMessage(), e));
            }
        }
        MultiException.throwIf((String)"Error restarting bundles", exceptions);
        return null;
    }

    @Override
    protected void executeOnBundle(Bundle bundle) throws Exception {
    }
}

