/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.AbstractNumberConverterTest;
import org.apache.commons.beanutils2.converters.DoubleConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DoubleConverterTest
extends AbstractNumberConverterTest<Double> {
    private Converter<Double> converter;

    @Override
    protected Class<Double> getExpectedType() {
        return Double.class;
    }

    protected DoubleConverter makeConverter() {
        return new DoubleConverter();
    }

    protected DoubleConverter makeConverter(Double defaultValue) {
        return new DoubleConverter(defaultValue);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Double.valueOf("-12");
        this.numbers[1] = Double.valueOf("13");
        this.numbers[2] = Double.valueOf("-22");
        this.numbers[3] = Double.valueOf("23");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Double.MIN_VALUE), "-17.2", "-1.1", "0.0", "1.1", "17.2", String.valueOf(Double.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Double[] expected = new Double[]{Double.MIN_VALUE, -17.2, -1.1, 0.0, 1.1, 17.2, Double.MAX_VALUE, 7.0, 8.0, 9.0, 10.0, 11.1, 12.2};
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((double)expected[i], (double)((Double)this.converter.convert(Double.class, input[i])), (double)1.0E-5, (String)(message[i] + " to Double"));
            Assertions.assertEquals((double)expected[i], (double)((Double)this.converter.convert(Double.TYPE, input[i])), (double)1.0E-5, (String)(message[i] + " to double"));
            Assertions.assertEquals((double)expected[i], (double)((Double)this.converter.convert((Class)null, input[i])), (double)1.0E-5, (String)(message[i] + " to null type"));
        }
    }
}

