/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Properties;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.Parser;
import org.apache.commons.cli.PosixParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class OptionGroupTest {
    private Options options;
    private final Parser parser = new PosixParser();

    OptionGroupTest() {
    }

    @BeforeEach
    public void setUp() {
        Option file = new Option("f", "file", false, "file to process");
        Option dir = new Option("d", "directory", false, "directory to process");
        OptionGroup optionGroup1 = new OptionGroup();
        optionGroup1.addOption(file);
        optionGroup1.addOption(dir);
        this.options = new Options().addOptionGroup(optionGroup1);
        Option section = new Option("s", "section", false, "section to process");
        Option chapter = new Option("c", "chapter", false, "chapter to process");
        OptionGroup optionGroup2 = new OptionGroup();
        optionGroup2.addOption(section);
        optionGroup2.addOption(chapter);
        this.options.addOptionGroup(optionGroup2);
        Option importOpt = new Option(null, "import", false, "section to process");
        Option exportOpt = new Option(null, "export", false, "chapter to process");
        OptionGroup optionGroup3 = new OptionGroup();
        optionGroup3.addOption(importOpt);
        optionGroup3.addOption(exportOpt);
        this.options.addOptionGroup(optionGroup3);
        this.options.addOption("r", "revision", false, "revision number");
    }

    @Test
    void testGetNames() {
        OptionGroup optionGroup = new OptionGroup();
        Assertions.assertFalse((boolean)optionGroup.isSelected());
        optionGroup.addOption(OptionBuilder.create((char)'a'));
        optionGroup.addOption(OptionBuilder.create((char)'b'));
        Assertions.assertNotNull((Object)optionGroup.getNames(), (String)"null names");
        Assertions.assertEquals((int)2, (int)optionGroup.getNames().size());
        Assertions.assertTrue((boolean)optionGroup.getNames().contains("a"));
        Assertions.assertTrue((boolean)optionGroup.getNames().contains("b"));
    }

    @Test
    void testNoOptionsExtraArgs() throws Exception {
        String[] args = new String[]{"arg1", "arg2"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertFalse((boolean)cl.hasOption("r"), (String)"Confirm -r is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("f"), (String)"Confirm -f is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("d"), (String)"Confirm -d is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("s"), (String)"Confirm -s is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is NOT set");
        Assertions.assertEquals((int)2, (int)cl.getArgList().size(), (String)"Confirm TWO extra args");
    }

    @Test
    void testSingleLongOption() throws Exception {
        String[] args = new String[]{"--file"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertFalse((boolean)cl.hasOption("r"), (String)"Confirm -r is NOT set");
        Assertions.assertTrue((boolean)cl.hasOption("f"), (String)"Confirm -f is set");
        Assertions.assertFalse((boolean)cl.hasOption("d"), (String)"Confirm -d is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("s"), (String)"Confirm -s is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is NOT set");
        Assertions.assertTrue((boolean)cl.getArgList().isEmpty(), (String)"Confirm no extra args");
    }

    @Test
    void testSingleOption() throws Exception {
        String[] args = new String[]{"-r"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertTrue((boolean)cl.hasOption("r"), (String)"Confirm -r is set");
        Assertions.assertFalse((boolean)cl.hasOption("f"), (String)"Confirm -f is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("d"), (String)"Confirm -d is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("s"), (String)"Confirm -s is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is NOT set");
        Assertions.assertTrue((boolean)cl.getArgList().isEmpty(), (String)"Confirm no extra args");
    }

    @Test
    void testSingleOptionFromGroup() throws Exception {
        String[] args = new String[]{"-f"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertFalse((boolean)cl.hasOption("r"), (String)"Confirm -r is NOT set");
        Assertions.assertTrue((boolean)cl.hasOption("f"), (String)"Confirm -f is set");
        Assertions.assertFalse((boolean)cl.hasOption("d"), (String)"Confirm -d is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("s"), (String)"Confirm -s is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is NOT set");
        Assertions.assertTrue((boolean)cl.getArgList().isEmpty(), (String)"Confirm no extra args");
    }

    @Test
    void testToString() {
        OptionGroup optionGroup1 = new OptionGroup();
        optionGroup1.addOption(new Option(null, "foo", false, "Foo"));
        optionGroup1.addOption(new Option(null, "bar", false, "Bar"));
        if (!"[--bar Bar, --foo Foo]".equals(optionGroup1.toString())) {
            Assertions.assertEquals((Object)"[--foo Foo, --bar Bar]", (Object)optionGroup1.toString());
        }
        OptionGroup optionGroup2 = new OptionGroup();
        optionGroup2.addOption(new Option("f", "foo", false, "Foo"));
        optionGroup2.addOption(new Option("b", "bar", false, "Bar"));
        if (!"[-b Bar, -f Foo]".equals(optionGroup2.toString())) {
            Assertions.assertEquals((Object)"[-f Foo, -b Bar]", (Object)optionGroup2.toString());
        }
    }

    @Test
    void testTwoLongOptionsFromGroup() throws Exception {
        String[] args = new String[]{"--file", "--directory"};
        AlreadySelectedException e = (AlreadySelectedException)Assertions.assertThrows(AlreadySelectedException.class, () -> this.parser.parse(this.options, args));
        Assertions.assertNotNull((Object)e.getOptionGroup(), (String)"null option group");
        Assertions.assertTrue((boolean)e.getOptionGroup().isSelected());
        Assertions.assertEquals((Object)"f", (Object)e.getOptionGroup().getSelected(), (String)"selected option");
        Assertions.assertEquals((Object)"d", (Object)e.getOption().getOpt(), (String)"option");
    }

    @Test
    void testTwoOptionsFromDifferentGroup() throws Exception {
        String[] args = new String[]{"-f", "-s"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertFalse((boolean)cl.hasOption("r"), (String)"Confirm -r is NOT set");
        Assertions.assertTrue((boolean)cl.hasOption("f"), (String)"Confirm -f is set");
        Assertions.assertFalse((boolean)cl.hasOption("d"), (String)"Confirm -d is NOT set");
        Assertions.assertTrue((boolean)cl.hasOption("s"), (String)"Confirm -s is set");
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is NOT set");
        Assertions.assertTrue((boolean)cl.getArgList().isEmpty(), (String)"Confirm NO extra args");
    }

    @Test
    void testTwoOptionsFromGroup() throws Exception {
        String[] args = new String[]{"-f", "-d"};
        AlreadySelectedException e = (AlreadySelectedException)Assertions.assertThrows(AlreadySelectedException.class, () -> this.parser.parse(this.options, args));
        Assertions.assertNotNull((Object)e.getOptionGroup(), (String)"null option group");
        Assertions.assertTrue((boolean)e.getOptionGroup().isSelected());
        Assertions.assertEquals((Object)"f", (Object)e.getOptionGroup().getSelected(), (String)"selected option");
        Assertions.assertEquals((Object)"d", (Object)e.getOption().getOpt(), (String)"option");
    }

    @Test
    void testTwoOptionsFromGroupWithProperties() throws Exception {
        String[] args = new String[]{"-f"};
        Properties properties = new Properties();
        properties.put("d", "true");
        CommandLine cl = this.parser.parse(this.options, args, properties);
        Assertions.assertTrue((boolean)cl.hasOption("f"));
        Assertions.assertFalse((boolean)cl.hasOption("d"));
    }

    @Test
    void testTwoValidLongOptions() throws Exception {
        String[] args = new String[]{"--revision", "--file"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertTrue((boolean)cl.hasOption("r"), (String)"Confirm -r is set");
        Assertions.assertTrue((boolean)cl.hasOption("f"), (String)"Confirm -f is set");
        Assertions.assertFalse((boolean)cl.hasOption("d"), (String)"Confirm -d is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("s"), (String)"Confirm -s is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is NOT set");
        Assertions.assertTrue((boolean)cl.getArgList().isEmpty(), (String)"Confirm no extra args");
    }

    @Test
    void testTwoValidOptions() throws Exception {
        String[] args = new String[]{"-r", "-f"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertTrue((boolean)cl.hasOption("r"), (String)"Confirm -r is set");
        Assertions.assertTrue((boolean)cl.hasOption("f"), (String)"Confirm -f is set");
        Assertions.assertFalse((boolean)cl.hasOption("d"), (String)"Confirm -d is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("s"), (String)"Confirm -s is NOT set");
        Assertions.assertFalse((boolean)cl.hasOption("c"), (String)"Confirm -c is NOT set");
        Assertions.assertTrue((boolean)cl.getArgList().isEmpty(), (String)"Confirm no extra args");
    }

    @Test
    void testValidLongOnlyOptions() throws Exception {
        CommandLine cl1 = this.parser.parse(this.options, new String[]{"--export"});
        Assertions.assertTrue((boolean)cl1.hasOption("export"), (String)"Confirm --export is set");
        CommandLine cl2 = this.parser.parse(this.options, new String[]{"--import"});
        Assertions.assertTrue((boolean)cl2.hasOption("import"), (String)"Confirm --import is set");
    }
}

