/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.queue.AbstractQueueTest;
import org.apache.commons.collections4.queue.PredicatedQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedQueueTest<E>
extends AbstractQueueTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = String.class::isInstance;

    protected Queue<E> decorateCollection(Queue<E> queue, Predicate<E> predicate) {
        return PredicatedQueue.predicatedQueue(queue, predicate);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new LinkedList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        return new LinkedList(Arrays.asList(this.getFullElements()));
    }

    @Override
    public Queue<E> makeFullCollection() {
        LinkedList queue = new LinkedList(Arrays.asList(this.getFullElements()));
        return this.decorateCollection(queue, this.truePredicate);
    }

    @Override
    public Queue<E> makeObject() {
        return this.decorateCollection(new LinkedList(), this.truePredicate);
    }

    public Queue<E> makeTestQueue() {
        return this.decorateCollection(new LinkedList(), this.testPredicate);
    }

    @Test
    public void testGet() {
        Queue<String> queue = this.makeTestQueue();
        Assertions.assertNull(queue.peek());
        queue.add("one");
        queue.add("two");
        queue.add("three");
        Assertions.assertEquals((Object)"one", queue.peek(), (String)"Queue get");
    }

    @Test
    public void testRemove() {
        Queue<String> queue = this.makeTestQueue();
        queue.add("one");
        Assertions.assertEquals((Object)"one", queue.poll(), (String)"Queue get");
        Assertions.assertNull(queue.peek());
    }
}

