/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.TemplateInterpreter;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.parser.JexlNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SomeTest {
    static AtomicInteger CALL406 = new AtomicInteger();

    SomeTest() {
    }

    @Test
    void test406b() {
        JexlEngine jexl = new JexlBuilder(){

            public JexlEngine create() {
                return new Engine406(this);
            }
        }.cache(64).strict(true).safe(false).create();
        String src = "`Call ${x}`";
        JexlScript script = jexl.createScript("`Call ${x}`", new String[]{"x"});
        Object result = script.execute(null, new Object[]{406});
        Assertions.assertEquals((Object)"Call 406", (Object)result);
        Assertions.assertEquals((int)1, (int)CALL406.get());
        result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"Call 42", (Object)result);
        Assertions.assertEquals((int)2, (int)CALL406.get());
    }

    @Test
    void testCustomFunctionPermissions() {
        HashMap<String, MyMath> funcs = new HashMap<String, MyMath>();
        funcs.put("math", new MyMath());
        JexlPermissions permissions = JexlPermissions.parse((String[])new String[]{"org.example.*"});
        JexlEngine jexl = new JexlBuilder().permissions(permissions).namespaces(funcs).create();
        MapContext jc = new MapContext();
        jc.set("pi", (Object)Math.PI);
        JexlExpression e = jexl.createExpression("math:cos(pi)");
        Number result = (Number)e.evaluate((JexlContext)jc);
        Assertions.assertEquals((int)-1, (int)result.intValue());
    }

    public static class MyMath {
        public double cos(double x) {
            return Math.cos(x);
        }
    }

    public static class TemplateInterpreter406
    extends TemplateInterpreter {
        protected TemplateInterpreter406(TemplateInterpreter.Arguments args) {
            super(args);
        }

        public Object interpret(JexlNode node) {
            CALL406.incrementAndGet();
            return super.interpret(node);
        }
    }

    public static class Engine406
    extends Engine {
        public Engine406(JexlBuilder conf) {
            super(conf);
        }

        public TemplateInterpreter createTemplateInterpreter(TemplateInterpreter.Arguments args) {
            return new TemplateInterpreter406(args);
        }
    }
}

