/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.FailedResource;
import net.sf.saxon.resource.MetadataResource;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.MappingJavaIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;

public class DirectoryCollection
extends AbstractResourceCollection {
    private final File dirFile;
    private SpaceStrippingRule whitespaceRules;

    public DirectoryCollection(Configuration config, String collectionURI, File file, URIQueryParameters params) throws XPathException {
        super(config);
        if (collectionURI == null) {
            throw new NullPointerException();
        }
        this.collectionURI = collectionURI;
        this.dirFile = file;
        this.params = params == null ? new URIQueryParameters("", config) : params;
    }

    @Override
    public boolean stripWhitespace(SpaceStrippingRule rules) {
        this.whitespaceRules = rules;
        return true;
    }

    @Override
    public Iterator<String> getResourceURIs(XPathContext context) {
        return this.directoryContents(this.dirFile, this.params);
    }

    @Override
    public Iterator<? extends Resource> getResources(XPathContext context) {
        ParseOptions options = this.optionsFromQueryParameters(this.params, context).withSpaceStrippingRule(this.whitespaceRules);
        Optional<Boolean> metadataParam = this.params.getMetaData();
        boolean metadata = metadataParam.isPresent() && metadataParam.get() != false;
        Iterator<String> resourceURIs = this.getResourceURIs(context);
        return new MappingJavaIterator<String, Resource>(resourceURIs, in -> {
            try {
                Resource resource;
                AbstractResourceCollection.InputDetails details = this.getInputDetails((String)in);
                details.resourceUri = in;
                details.parseOptions = options;
                if (this.params.getContentType().isPresent()) {
                    details.contentType = this.params.getContentType().get();
                }
                if ((resource = this.makeResource(context, details)) != null) {
                    if (metadata) {
                        return this.makeMetadataResource(resource, details, context);
                    }
                    return resource;
                }
                return null;
            }
            catch (XPathException e) {
                Optional<Integer> onError = this.params.getOnError();
                if (onError.isPresent() && onError.get() == 1) {
                    return new FailedResource((String)in, e);
                }
                if (onError.isPresent() && onError.get() == 2) {
                    context.getController().warning("collection(): failed to parse " + in + ": " + e.getMessage(), e.showErrorCode(), null);
                    return null;
                }
                return null;
            }
        });
    }

    private MetadataResource makeMetadataResource(Resource resource, AbstractResourceCollection.InputDetails details, XPathContext context) {
        HashMap<String, GroundedValue> properties;
        block6: {
            properties = new HashMap<String, GroundedValue>();
            try {
                URI uri = new URI(resource.getResourceURI());
                if (details.contentType != null) {
                    properties.put("content-type", StringValue.makeStringValue(details.contentType));
                }
                if (details.encoding != null) {
                    properties.put("encoding", StringValue.makeStringValue(details.encoding));
                }
                if (!"file".equals(uri.getScheme())) break block6;
                File file = new File(uri);
                properties.put("path", StringValue.makeStringValue(file.getPath()));
                properties.put("absolute-path", StringValue.makeStringValue(file.getAbsolutePath()));
                properties.put("canonical-path", StringValue.makeStringValue(file.getCanonicalPath()));
                properties.put("can-read", BooleanValue.get(file.canRead()));
                properties.put("can-write", BooleanValue.get(file.canWrite()));
                properties.put("can-execute", BooleanValue.get(file.canExecute()));
                properties.put("is-hidden", BooleanValue.get(file.isHidden()));
                try {
                    properties.put("last-modified", DateTimeValue.fromJavaTime(file.lastModified()));
                }
                catch (XPathException xPathException) {
                    // empty catch block
                }
                properties.put("length", new Int64Value(file.length()));
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return new MetadataResource(resource.getResourceURI(), resource, properties, context);
    }

    protected Iterator<String> directoryContents(File directory, URIQueryParameters params) {
        FilenameFilter filter = null;
        boolean recurse = false;
        if (params != null) {
            Optional<Boolean> r;
            Optional<FilenameFilter> f = params.getFilenameFilter();
            if (f.isPresent()) {
                filter = f.get();
            }
            if ((r = params.getRecurse()).isPresent()) {
                recurse = r.get();
            }
        }
        Stack<Iterator<File>> directories = new Stack<Iterator<File>>();
        directories.push(Arrays.asList(directory.listFiles(filter)).iterator());
        return new DirectoryIterator(directories, recurse, filter);
    }

    private static class DirectoryIterator
    implements Iterator<String> {
        private final Stack<Iterator<File>> directories;
        private final FilenameFilter filter;
        private final boolean recurse;
        private String nextItem = null;

        public DirectoryIterator(Stack<Iterator<File>> directories, boolean recurse, FilenameFilter filter) {
            this.directories = directories;
            this.recurse = recurse;
            this.filter = filter;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public String next() {
            String s = this.nextItem;
            this.advance();
            return s;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            if (this.directories.isEmpty()) {
                this.nextItem = null;
            } else {
                Iterator<File> files = this.directories.peek();
                while (!files.hasNext()) {
                    this.directories.pop();
                    if (this.directories.isEmpty()) {
                        this.nextItem = null;
                        return;
                    }
                    files = this.directories.peek();
                }
                File nextFile = files.next();
                if (nextFile.isDirectory()) {
                    if (this.recurse) {
                        this.directories.push(Arrays.asList(nextFile.listFiles(this.filter)).iterator());
                    }
                    this.advance();
                } else {
                    this.nextItem = nextFile.toURI().toString();
                }
            }
        }
    }
}

