/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.inject.AbstractModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.log.LogLevel;
import org.apache.guacamole.properties.EnumGuacamoleProperty;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(LogModule.class);
    private final Environment environment;
    private static final EnumGuacamoleProperty<LogLevel> LOG_LEVEL = new /* Unavailable Anonymous Inner Class!! */;

    public LogModule(Environment environment) {
        this.environment = environment;
    }

    private InputStream getLogbackConfiguration() {
        LogLevel level;
        File logbackFile = new File(this.environment.getGuacamoleHome(), "logback.xml");
        if (logbackFile.exists()) {
            try {
                this.logger.info("Loading logback configuration from \"{}\".", (Object)logbackFile);
                return new FileInputStream(logbackFile);
            }
            catch (FileNotFoundException e) {
                this.logger.info("Logback configuration could not be read from \"{}\": {}", (Object)logbackFile, (Object)e.getMessage());
            }
        }
        try {
            level = (LogLevel)this.environment.getProperty((GuacamoleProperty)LOG_LEVEL, (Object)LogLevel.INFO);
            this.logger.info("Logging will be at the \"{}\" level.", (Object)level.getCanonicalName());
        }
        catch (GuacamoleException e) {
            level = LogLevel.INFO;
            this.logger.error("Falling back to \"{}\" log level: {}", (Object)level.getCanonicalName(), (Object)e.getMessage());
        }
        return level.getLogbackConfiguration();
    }

    protected void configure() {
        try (InputStream logbackConfiguration = this.getLogbackConfiguration();){
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            context.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            configurator.doConfigure(logbackConfiguration);
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        }
        catch (JoranException e) {
            this.logger.error("Initialization of logback failed: {}", (Object)e.getMessage());
            this.logger.debug("Unable to load logback configuration.", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.warn("Logback configuration file could not be cleanly closed: {}", (Object)e.getMessage());
            this.logger.debug("Failed to close logback configuration file.", (Throwable)e);
        }
    }
}

