/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.exception.UcanaccessSQLException;

public class CreateTableCommand
implements ICommand {
    private final String execId;
    private final String tableName;
    private String[] types;
    private String[] defaults;
    private Boolean[] notNulls;
    private Map<String, String> columnMap;

    public CreateTableCommand(String _tableName, String _execId) {
        this.tableName = _tableName;
        this.execId = _execId;
    }

    public CreateTableCommand(String tn, String execId2, Map<String, String> _columnMap, String[] _types, String[] _defaults, Boolean[] _notNulls) {
        this(tn, execId2);
        this.types = _types;
        this.defaults = _defaults;
        this.notNulls = _notNulls;
        this.columnMap = _columnMap;
    }

    public CreateTableCommand(String tn, String execId2, Map<String, String> columnMap2) {
        this(tn, execId2, columnMap2, null, null, null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTableCommand other = (CreateTableCommand)obj;
        return Objects.equals(this.tableName, other.tableName);
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public ICommand.CommandType getType() {
        return ICommand.CommandType.DDL;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        try {
            Persist2Jet p2a = new Persist2Jet();
            p2a.createTable(this.tableName, this.columnMap, this.types, this.defaults, this.notNulls);
        }
        catch (IOException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
        return null;
    }

    @Override
    public IFeedbackAction rollback() {
        return null;
    }
}

