/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePainterExtension;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.PipelineUnitTestSetLocation;

@ExtensionPoint(id="DrawInputDataSetOnTransformExtensionPoint", description="Draws a marker on top of a transform if it has an input data set defined for it", extensionPointId="PipelinePainterTransform")
public class DrawInputDataSetOnTransformExtensionPoint
implements IExtensionPoint<PipelinePainterExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, PipelinePainterExtension ext) throws HopException {
        TransformMeta transformMeta = ext.transformMeta;
        PipelineMeta pipelineMeta = ext.pipelineMeta;
        PipelineUnitTest unitTest = null;
        if (ext.stateMap != null) {
            unitTest = (PipelineUnitTest)ext.stateMap.get("ActiveUnitTest");
        }
        if (unitTest != null) {
            this.drawInputDataSetMarker(ext, transformMeta, unitTest, ext.areaOwners);
        }
    }

    private void drawInputDataSetMarker(PipelinePainterExtension ext, TransformMeta transformMeta, PipelineUnitTest unitTest, List<AreaOwner> areaOwners) {
        PipelineUnitTestSetLocation location = unitTest.findInputLocation(transformMeta.getName());
        if (location == null) {
            return;
        }
        String dataSetName = Const.NVL((String)location.getDataSetName(), (String)"");
        IGc gc = ext.gc;
        int iconSize = ext.iconSize;
        int x = ext.x1;
        int y = ext.y1;
        gc.setLineWidth(transformMeta.isSelected() ? 2 : 1);
        gc.setForeground(IGc.EColor.CRYSTAL);
        gc.setBackground(IGc.EColor.LIGHTGRAY);
        gc.setFont(IGc.EFont.GRAPH);
        Point textExtent = gc.textExtent(dataSetName);
        textExtent.x += 6;
        textExtent.y += 6;
        int arrowSize = textExtent.y;
        Point point = new Point(x - textExtent.x - arrowSize - 2, y + (iconSize - textExtent.y) / 2);
        int[] arrow = new int[]{point.x, point.y, point.x + textExtent.x, point.y, point.x + textExtent.x + arrowSize, point.y + textExtent.y / 2, point.x + textExtent.x, point.y + textExtent.y, point.x, point.y + textExtent.y};
        gc.fillPolygon(arrow);
        gc.drawPolygon(arrow);
        gc.drawText(dataSetName, point.x + 3, point.y + 3);
        areaOwners.add(new AreaOwner(AreaOwner.AreaType.CUSTOM, point.x, point.y, textExtent.x, textExtent.y, ext.offset, (Object)"Input_DataSet", (Object)transformMeta.getName()));
    }
}

