/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.beam.runners.spark.structuredstreaming.translation.PipelineTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.SideInputValues;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderProvider;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.construction.TransformInputs;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Tuple2;
import scala.reflect.ClassTag;

@Internal
public abstract class TransformTranslator<@UnknownKeyFor InT extends @UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor OutT extends @UnknownKeyFor @NonNull @Initialized POutput, @UnknownKeyFor TransformT extends @UnknownKeyFor @NonNull @Initialized PTransform<InT, OutT>> {
    protected final @UnknownKeyFor @NonNull @Initialized float complexityFactor;

    protected TransformTranslator(@UnknownKeyFor @NonNull @Initialized float complexityFactor) {
        this.complexityFactor = complexityFactor;
    }

    protected abstract void translate(TransformT var1, @UnknownKeyFor @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context var2) throws @UnknownKeyFor @NonNull @Initialized IOException;

    final void translate(TransformT transform, @UnknownKeyFor @NonNull @Initialized AppliedPTransform<InT, OutT, TransformT> appliedTransform, @UnknownKeyFor @NonNull @Initialized PipelineTranslator.TranslationState translationState) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.translate(transform, new Context(appliedTransform, translationState));
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean canTranslate(TransformT transform) {
        return true;
    }

    protected <T> @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder(@UnknownKeyFor @NonNull @Initialized PCollection<T> pc) {
        return pc.getWindowingStrategy().getWindowFn().windowCoder();
    }

    protected class Context
    implements PipelineTranslator.TranslationState {
        private final @UnknownKeyFor @NonNull @Initialized AppliedPTransform<InT, OutT, TransformT> transform;
        private final @UnknownKeyFor @NonNull @Initialized PipelineTranslator.TranslationState state;
        private @MonotonicNonNull InT pIn = null;
        private @MonotonicNonNull OutT pOut = null;

        private Context(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<InT, OutT, TransformT> transform, PipelineTranslator.TranslationState state) {
            this.transform = transform;
            this.state = state;
        }

        public InT getInput() {
            if (this.pIn == null) {
                this.pIn = (PInput)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.transform));
            }
            return this.pIn;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getInputs() {
            return this.transform.getInputs();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputs() {
            return this.transform.getOutputs();
        }

        public OutT getOutput() {
            if (this.pOut == null) {
                this.pOut = (POutput)Iterables.getOnlyElement(this.transform.getOutputs().values());
            }
            return this.pOut;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized PCollection<T> getOutput(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag) {
            PCollection pc = (PCollection)this.transform.getOutputs().get(tag);
            if (pc == null) {
                throw new IllegalStateException("No output for tag " + tag);
            }
            return pc;
        }

        public @UnknownKeyFor @NonNull @Initialized AppliedPTransform<InT, OutT, TransformT> getCurrentTransform() {
            return this.transform;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getDataset(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection) {
            return this.state.getDataset(pCollection);
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized SideInputValues<T>> getSideInputBroadcast(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, @UnknownKeyFor @NonNull @Initialized SideInputValues.Loader<T> loader) {
            return this.state.getSideInputBroadcast(pCollection, loader);
        }

        @Override
        public <T> void putDataset(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> dataset, @UnknownKeyFor @NonNull @Initialized boolean cache) {
            this.state.putDataset(pCollection, dataset, cache);
        }

        public <InputT, T> void putUnresolved(@UnknownKeyFor @NonNull @Initialized PCollection<T> out, @UnknownKeyFor @NonNull @Initialized PipelineTranslator.UnresolvedTranslation<InputT, T> unresolved) {
            this.state.putUnresolved(out, unresolved);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isLeaf(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pCollection) {
            return this.state.isLeaf(pCollection);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> getOptionsSupplier() {
            return this.state.getOptionsSupplier();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PipelineOptions getOptions() {
            return this.state.getOptions();
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> createDataset(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> data, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> enc) {
            return data.isEmpty() ? this.getSparkSession().emptyDataset(enc) : this.getSparkSession().createDataset(data, enc);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Broadcast<T> broadcast(T value) {
            return this.getSparkSession().sparkContext().broadcast(value, ClassTag.AnyRef());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SparkSession getSparkSession() {
            return this.state.getSparkSession();
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Encoder<T> encoderOf(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized EncoderProvider.Factory<T> factory) {
            return this.state.encoderOf(coder, factory);
        }

        public <T1, T2> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized Tuple2<T1, T2>> tupleEncoder(@UnknownKeyFor @NonNull @Initialized Encoder<T1> e1, @UnknownKeyFor @NonNull @Initialized Encoder<T2> e2) {
            return Encoders.tuple(e1, e2);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> windowedEncoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return EncoderHelpers.windowedValueEncoder(this.encoderOf(coder), this.windowEncoder());
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> windowedEncoder(@UnknownKeyFor @NonNull @Initialized Encoder<T> enc) {
            return EncoderHelpers.windowedValueEncoder(enc, this.windowEncoder());
        }

        public <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> windowedEncoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
            return EncoderHelpers.windowedValueEncoder(this.encoderOf(coder), this.encoderOf(windowCoder));
        }

        public @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowEncoder() {
            Preconditions.checkState((!this.getInputs().isEmpty() ? 1 : 0) != 0, (Object)"Transform has no inputs, cannot get windowCoder!");
            return this.encoderOf(TransformTranslator.this.windowCoder((PCollection)this.getInput()));
        }
    }
}

