/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WebPathParser {
    public @UnknownKeyFor @NonNull @Initialized DicomWebPath parseDicomWebpath(@UnknownKeyFor @NonNull @Initialized String unparsedWebpath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String[] webPathSplit = unparsedWebpath.split("/dicomWeb/");
        if (webPathSplit.length != 2) {
            throw new IOException("Invalid DICOM web path");
        }
        DicomWebPath dicomWebPath = new DicomWebPath();
        dicomWebPath.dicomStorePath = webPathSplit[0];
        String[] storePathElements = dicomWebPath.dicomStorePath.split("/");
        dicomWebPath.project = storePathElements[1];
        dicomWebPath.location = storePathElements[3];
        dicomWebPath.dataset = storePathElements[5];
        dicomWebPath.storeId = storePathElements[7];
        String[] searchParameters = webPathSplit[1].split("/");
        if (searchParameters.length < 2) {
            throw new IOException("Invalid DICOM web path");
        }
        dicomWebPath.studyId = searchParameters[1];
        dicomWebPath.seriesId = searchParameters[3];
        dicomWebPath.instanceId = searchParameters[5];
        return dicomWebPath;
    }

    public static class DicomWebPath {
        public @UnknownKeyFor @NonNull @Initialized String studyId = "";
        public @UnknownKeyFor @NonNull @Initialized String seriesId = "";
        public @UnknownKeyFor @NonNull @Initialized String instanceId = "";
        public @UnknownKeyFor @NonNull @Initialized String dicomStorePath = "";
        public @UnknownKeyFor @NonNull @Initialized String project = "";
        public @UnknownKeyFor @NonNull @Initialized String location = "";
        public @UnknownKeyFor @NonNull @Initialized String dataset = "";
        public @UnknownKeyFor @NonNull @Initialized String storeId = "";
    }
}

