/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.documentation;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.documentation.DocBuilder;
import org.apache.hop.documentation.DocDelegate;
import org.apache.hop.documentation.Toc;
import org.apache.hop.documentation.TocEntry;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelineSvgPainter;

public class PipelineDocDelegate
extends DocDelegate {
    private final ILogChannel log;

    public PipelineDocDelegate(DocBuilder builder) {
        super(builder);
        this.log = builder.getLog();
    }

    public void buildPipelineDocumentation(Toc toc, FileObject targetRootFolder, FileObject sourceFolder, FileObject targetFolder, String relativeName, FileObject file) throws Exception {
        String targetFileName = this.calculateTargetDocumentationFile(targetFolder, file);
        String relativeSourceFile = sourceFolder.getName().getRelativeName(file.getName());
        this.log.logBasic(" - documenting pipeline: " + relativeSourceFile + " to " + targetFileName);
        PipelineMeta pipelineMeta = new PipelineMeta(file.getName().getPath(), (IHopMetadataProvider)this.builder.getMetadataProvider(), this.builder.getVariables());
        String pipelineName = pipelineMeta.getName();
        StringBuilder content = new StringBuilder();
        content.append("---").append(Const.CR).append("title: Pipeline ").append(pipelineName).append(Const.CR).append("---").append(Const.CR).append(Const.CR);
        this.addDetails((AbstractMeta)pipelineMeta, content, relativeSourceFile);
        String pipelineSvg = PipelineSvgPainter.generatePipelineSvg((PipelineMeta)pipelineMeta, (float)1.0f, (IVariables)this.builder.getVariables(), (DPoint)new DPoint(0.0, 0.0), (float)1.0f, (int)0);
        String relativeSvgFilename = this.calculateTargetImageFile(pipelineName, "pipeline");
        String svgFilename = targetRootFolder.getName().getPath() + "/assets/images/" + relativeSvgFilename;
        this.builder.saveFile(svgFilename, pipelineSvg);
        String relativeSvgPath = HopVfs.getFileObject((String)targetFileName).getParent().getName().getRelativeName(HopVfs.getFileObject((String)svgFilename).getName());
        content.append("## Image ").append(Const.CR).append(Const.CR).append("![*Image of pipeline : ").append(pipelineName).append("*]").append("(").append(relativeSvgPath).append(" \"").append("Pipeline ").append(pipelineName).append("\"").append(")").append(Const.CR).append(Const.CR);
        if (this.builder.isIncludingNotes() && !pipelineMeta.getNotes().isEmpty()) {
            content.append("## Notes : ").append(Const.CR).append(Const.CR);
            ArrayList<NotePadMeta> notes = new ArrayList<NotePadMeta>(pipelineMeta.getNotes());
            notes.sort(Comparator.comparing(NotePadMeta::getNote));
            for (NotePadMeta note : notes) {
                content.append(note.getNote()).append(Const.CR);
            }
            content.append(Const.CR);
        }
        this.builder.saveFile(targetFileName, content.toString());
        String relativeTargetFilename = targetRootFolder.getName().getRelativeName(HopVfs.getFileObject((String)targetFileName).getName());
        toc.getEntries().add(new TocEntry(relativeName, "Pipeline", pipelineName, relativeSourceFile, relativeTargetFilename));
    }
}

