/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.utils.FBUtilities;

public interface IEndpointSnitch {
    public String getRack(InetAddressAndPort var1);

    default public String getLocalRack() {
        return this.getRack(FBUtilities.getBroadcastAddressAndPort());
    }

    public String getDatacenter(InetAddressAndPort var1);

    default public String getLocalDatacenter() {
        return this.getDatacenter(FBUtilities.getBroadcastAddressAndPort());
    }

    default public String getDatacenter(InetSocketAddress endpoint) {
        return this.getDatacenter(InetAddressAndPort.getByAddress(endpoint));
    }

    default public String getDatacenter(Replica replica) {
        return this.getDatacenter(replica.endpoint());
    }

    public <C extends ReplicaCollection<? extends C>> C sortedByProximity(InetAddressAndPort var1, C var2);

    public int compareEndpoints(InetAddressAndPort var1, Replica var2, Replica var3);

    public void gossiperStarting();

    public boolean isWorthMergingForRangeQuery(ReplicaCollection<?> var1, ReplicaCollection<?> var2, ReplicaCollection<?> var3);

    default public boolean validate(Set<String> datacenters, Set<String> racks) {
        return true;
    }
}

