/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.UpdateMaterializedViewRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.MaterializedView;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.FieldMask;
import com.google.protobuf.util.FieldMaskUtil;
import javax.annotation.Nonnull;

public final class UpdateMaterializedViewRequest {
    private final UpdateMaterializedViewRequest.Builder requestBuilder;
    private final String instanceId;
    private final String materializedViewId;

    public static UpdateMaterializedViewRequest of(@Nonnull MaterializedView materializedView) {
        return new UpdateMaterializedViewRequest(materializedView.getId(), materializedView.getInstanceId(), com.google.bigtable.admin.v2.UpdateMaterializedViewRequest.newBuilder().setMaterializedView(materializedView.toProto()));
    }

    public static UpdateMaterializedViewRequest of(@Nonnull String instanceId, @Nonnull String materializedViewId) {
        return new UpdateMaterializedViewRequest(materializedViewId, instanceId, com.google.bigtable.admin.v2.UpdateMaterializedViewRequest.newBuilder());
    }

    private UpdateMaterializedViewRequest(@Nonnull String materializedViewId, @Nonnull String instanceId, @Nonnull UpdateMaterializedViewRequest.Builder requestBuilder) {
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId must be set");
        Preconditions.checkNotNull((Object)materializedViewId, (Object)"materializedViewId must be set");
        Preconditions.checkNotNull((Object)requestBuilder, (Object)"proto builder must be set");
        this.instanceId = instanceId;
        this.materializedViewId = materializedViewId;
        this.requestBuilder = requestBuilder;
    }

    public UpdateMaterializedViewRequest setDeletionProtection(boolean deletionProtection) {
        this.requestBuilder.getMaterializedViewBuilder().setDeletionProtection(deletionProtection);
        this.updateFieldMask(6);
        return this;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(com.google.bigtable.admin.v2.MaterializedView.class, (int[])new int[]{fieldNumber});
        this.requestBuilder.setUpdateMask(FieldMaskUtil.union((FieldMask)this.requestBuilder.getUpdateMask(), (FieldMask)newMask, (FieldMask[])new FieldMask[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMaterializedViewRequest that = (UpdateMaterializedViewRequest)o;
        return Objects.equal((Object)this.requestBuilder.build(), (Object)that.requestBuilder.build()) && Objects.equal((Object)this.materializedViewId, (Object)that.materializedViewId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.build(), this.materializedViewId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.UpdateMaterializedViewRequest toProto(@Nonnull String projectId) {
        this.requestBuilder.getMaterializedViewBuilder().setName(NameUtil.formatMaterializedViewName(projectId, this.instanceId, this.materializedViewId));
        return this.requestBuilder.build();
    }
}

