/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.models.AutoValue_Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
@AutoValue
public abstract class Row
implements Serializable {
    public static Comparator<Row> compareByKey() {
        return new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                return ByteStringComparator.INSTANCE.compare(r1.getKey(), r2.getKey());
            }
        };
    }

    @InternalApi
    public static Row create(ByteString key, List<RowCell> cells) {
        return new AutoValue_Row(key, cells);
    }

    @Nonnull
    public abstract ByteString getKey();

    public abstract List<RowCell> getCells();

    public List<RowCell> getCells(@Nonnull String family) {
        Preconditions.checkNotNull((Object)family, (Object)"family");
        int start = this.getFirst(family, null);
        if (start < 0) {
            return ImmutableList.of();
        }
        int end = this.getLast(family, null, start);
        return this.getCells().subList(start, end + 1);
    }

    public List<RowCell> getCells(@Nonnull String family, @Nonnull String qualifier) {
        Preconditions.checkNotNull((Object)family, (Object)"family");
        Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier");
        return this.getCells(family, ByteString.copyFromUtf8((String)qualifier));
    }

    public List<RowCell> getCells(@Nonnull String family, @Nonnull ByteString qualifier) {
        Preconditions.checkNotNull((Object)family, (Object)"family");
        Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier");
        int start = this.getFirst(family, qualifier);
        if (start < 0) {
            return ImmutableList.of();
        }
        int end = this.getLast(family, qualifier, start);
        return this.getCells().subList(start, end + 1);
    }

    private int getFirst(@Nonnull String family, @Nullable ByteString qualifier) {
        int low = 0;
        int high = this.getCells().size();
        int index = -1;
        while (low < high) {
            int mid = (high + low) / 2;
            RowCell midCell = this.getCells().get(mid);
            int c = midCell.getFamily().compareTo(family);
            if (c == 0 && qualifier != null) {
                c = ByteStringComparator.INSTANCE.compare(midCell.getQualifier(), qualifier);
            }
            if (c < 0) {
                low = mid + 1;
                continue;
            }
            if (c == 0) {
                index = mid;
                high = mid;
                continue;
            }
            high = mid;
        }
        return index;
    }

    private int getLast(@Nonnull String family, @Nullable ByteString qualifier, int startIndex) {
        int low = startIndex;
        int high = this.getCells().size();
        int index = -1;
        while (low < high) {
            int mid = (high + low) / 2;
            RowCell midCell = this.getCells().get(mid);
            int c = midCell.getFamily().compareTo(family);
            if (c == 0 && qualifier != null) {
                c = ByteStringComparator.INSTANCE.compare(midCell.getQualifier(), qualifier);
            }
            if (c < 0) {
                low = mid + 1;
                continue;
            }
            if (c == 0) {
                index = mid;
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return index;
    }
}

