/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.util.Locale;

public final class OS {
    public static final String FAMILY_9X = "win9x";
    public static final String FAMILY_DOS = "dos";
    public static final String FAMILY_MAC = "mac";
    public static final String FAMILY_NETWARE = "netware";
    public static final String FAMILY_NT = "winnt";
    public static final String FAMILY_OS2 = "os/2";
    public static final String FAMILY_OS400 = "os/400";
    public static final String FAMILY_TANDEM = "tandem";
    public static final String FAMILY_UNIX = "unix";
    public static final String FAMILY_VMS = "openvms";
    public static final String FAMILY_WINDOWS = "windows";
    public static final String FAMILY_ZOS = "z/os";
    private static final String DARWIN = "darwin";
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ROOT);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.ROOT);
    private static final String PATH_SEP = File.pathSeparator;

    public static boolean isArch(String arch) {
        return OS.isOs(null, null, arch, null);
    }

    private static boolean isFamily(String family) {
        return OS.isOs(family, null, null, null);
    }

    public static boolean isFamilyDOS() {
        return OS.isFamily(FAMILY_DOS);
    }

    public static boolean isFamilyMac() {
        return OS.isFamily(FAMILY_MAC);
    }

    public static boolean isFamilyNetware() {
        return OS.isFamily(FAMILY_NETWARE);
    }

    public static boolean isFamilyOpenVms() {
        return OS.isFamily(FAMILY_VMS);
    }

    public static boolean isFamilyOS2() {
        return OS.isFamily(FAMILY_OS2);
    }

    public static boolean isFamilyOS400() {
        return OS.isFamily(FAMILY_OS400);
    }

    public static boolean isFamilyTandem() {
        return OS.isFamily(FAMILY_TANDEM);
    }

    public static boolean isFamilyUnix() {
        return OS.isFamily(FAMILY_UNIX);
    }

    public static boolean isFamilyWin9x() {
        return OS.isFamily(FAMILY_9X);
    }

    public static boolean isFamilyWindows() {
        return OS.isFamily(FAMILY_WINDOWS);
    }

    public static boolean isFamilyWinNT() {
        return OS.isFamily(FAMILY_NT);
    }

    public static boolean isFamilyZOS() {
        return OS.isFamily(FAMILY_ZOS);
    }

    public static boolean isName(String name) {
        return OS.isOs(null, name, null, null);
    }

    public static boolean isOs(String family, String name, String arch, String version) {
        boolean retValue = false;
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (family != null) {
                boolean isWindows = OS_NAME.contains(FAMILY_WINDOWS);
                boolean is9x = false;
                boolean isNT = false;
                if (isWindows) {
                    is9x = OS_NAME.contains("95") || OS_NAME.contains("98") || OS_NAME.contains("me") || OS_NAME.contains("ce");
                    isNT = !is9x;
                }
                switch (family) {
                    case "windows": {
                        isFamily = isWindows;
                        break;
                    }
                    case "win9x": {
                        isFamily = isWindows && is9x;
                        break;
                    }
                    case "winnt": {
                        isFamily = isWindows && isNT;
                        break;
                    }
                    case "os/2": {
                        isFamily = OS_NAME.contains(FAMILY_OS2);
                        break;
                    }
                    case "netware": {
                        isFamily = OS_NAME.contains(FAMILY_NETWARE);
                        break;
                    }
                    case "dos": {
                        isFamily = PATH_SEP.equals(";") && !OS.isFamily(FAMILY_NETWARE);
                        break;
                    }
                    case "mac": {
                        isFamily = OS_NAME.contains(FAMILY_MAC) || OS_NAME.contains(DARWIN);
                        break;
                    }
                    case "tandem": {
                        isFamily = OS_NAME.contains("nonstop_kernel");
                        break;
                    }
                    case "unix": {
                        isFamily = PATH_SEP.equals(":") && !OS.isFamily(FAMILY_VMS) && (!OS.isFamily(FAMILY_MAC) || OS_NAME.endsWith("x") || OS_NAME.contains(DARWIN));
                        break;
                    }
                    case "z/os": {
                        isFamily = OS_NAME.contains(FAMILY_ZOS) || OS_NAME.contains("os/390");
                        break;
                    }
                    case "os/400": {
                        isFamily = OS_NAME.contains(FAMILY_OS400);
                        break;
                    }
                    case "openvms": {
                        isFamily = OS_NAME.contains(FAMILY_VMS);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Don't know how to detect OS family \"" + family + "\"");
                    }
                }
            }
            if (name != null) {
                isName = name.equals(OS_NAME);
            }
            if (arch != null) {
                isArch = arch.equals(OS_ARCH);
            }
            if (version != null) {
                isVersion = version.equals(OS_VERSION);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }

    public static boolean isVersion(String version) {
        return OS.isOs(null, null, null, version);
    }

    private OS() {
    }
}

