/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.transforms.windowing.AfterAll;
import org.apache.beam.sdk.transforms.windowing.AfterEach;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterSynchronizedProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.OrFinallyTrigger;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.ReshuffleTrigger;
import org.apache.beam.sdk.transforms.windowing.TimestampTransform;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class TriggerTranslation
implements Serializable {
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized ProtoConverter CONVERTER = new ProtoConverter();

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger toProto(@UnknownKeyFor @NonNull @Initialized Trigger trigger) {
        return CONVERTER.convertTrigger(trigger);
    }

    public static @UnknownKeyFor @NonNull @Initialized Trigger fromProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger triggerProto) {
        switch (triggerProto.getTriggerCase()) {
            case AFTER_ALL: {
                return AfterAll.of(TriggerTranslation.protosToTriggers(triggerProto.getAfterAll().getSubtriggersList()));
            }
            case AFTER_ANY: {
                return AfterFirst.of(TriggerTranslation.protosToTriggers(triggerProto.getAfterAny().getSubtriggersList()));
            }
            case AFTER_EACH: {
                return AfterEach.inOrder(TriggerTranslation.protosToTriggers(triggerProto.getAfterEach().getSubtriggersList()));
            }
            case AFTER_END_OF_WINDOW: {
                RunnerApi.Trigger.AfterEndOfWindow eowProto = triggerProto.getAfterEndOfWindow();
                if (!eowProto.hasEarlyFirings() && !eowProto.hasLateFirings()) {
                    return AfterWatermark.pastEndOfWindow();
                }
                if (triggerProto.getAfterEndOfWindow().hasEarlyFirings()) {
                    AfterWatermark.AfterWatermarkEarlyAndLate trigger = AfterWatermark.pastEndOfWindow().withEarlyFirings((Trigger.OnceTrigger)TriggerTranslation.fromProto(triggerProto.getAfterEndOfWindow().getEarlyFirings()));
                    if (triggerProto.getAfterEndOfWindow().hasLateFirings()) {
                        trigger = trigger.withLateFirings((Trigger.OnceTrigger)TriggerTranslation.fromProto(triggerProto.getAfterEndOfWindow().getLateFirings()));
                    }
                    return trigger;
                }
                return AfterWatermark.pastEndOfWindow().withLateFirings((Trigger.OnceTrigger)TriggerTranslation.fromProto(eowProto.getLateFirings()));
            }
            case AFTER_PROCESSING_TIME: {
                AfterProcessingTime trigger = AfterProcessingTime.pastFirstElementInPane();
                block20: for (RunnerApi.TimestampTransform transform : triggerProto.getAfterProcessingTime().getTimestampTransformsList()) {
                    switch (transform.getTimestampTransformCase()) {
                        case ALIGN_TO: {
                            trigger = trigger.alignedTo(Duration.millis((long)transform.getAlignTo().getPeriod()), new Instant(transform.getAlignTo().getOffset()));
                            continue block20;
                        }
                        case DELAY: {
                            trigger = trigger.plusDelayOf(Duration.millis((long)transform.getDelay().getDelayMillis()));
                            continue block20;
                        }
                        case TIMESTAMPTRANSFORM_NOT_SET: {
                            throw new IllegalArgumentException(String.format("Required field 'timestamp_transform' not set in %s", transform));
                        }
                    }
                    throw new IllegalArgumentException(String.format("Unknown timestamp transform case: %s", transform.getTimestampTransformCase()));
                }
                return trigger;
            }
            case AFTER_SYNCHRONIZED_PROCESSING_TIME: {
                return AfterSynchronizedProcessingTime.ofFirstElement();
            }
            case ALWAYS: {
                return new ReshuffleTrigger();
            }
            case ELEMENT_COUNT: {
                return AfterPane.elementCountAtLeast(triggerProto.getElementCount().getElementCount());
            }
            case NEVER: {
                return Never.ever();
            }
            case OR_FINALLY: {
                return TriggerTranslation.fromProto(triggerProto.getOrFinally().getMain()).orFinally((Trigger.OnceTrigger)TriggerTranslation.fromProto(triggerProto.getOrFinally().getFinally()));
            }
            case REPEAT: {
                return Repeatedly.forever(TriggerTranslation.fromProto(triggerProto.getRepeat().getSubtrigger()));
            }
            case DEFAULT: {
                return DefaultTrigger.of();
            }
            case TRIGGER_NOT_SET: {
                throw new IllegalArgumentException(String.format("Required field 'trigger' not set in %s", triggerProto));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown trigger case: %s", triggerProto.getTriggerCase()));
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> protosToTriggers(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger> triggers) {
        ArrayList result = Lists.newArrayList();
        for (RunnerApi.Trigger trigger : triggers) {
            result.add(TriggerTranslation.fromProto(trigger));
        }
        return result;
    }

    private TriggerTranslation() {
    }

    @VisibleForTesting
    static class ProtoConverter {
        ProtoConverter() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertTrigger(@UnknownKeyFor @NonNull @Initialized Trigger trigger) {
            Method evaluationMethod = this.getEvaluationMethod(trigger.getClass());
            return this.tryConvert(evaluationMethod, trigger);
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger tryConvert(@UnknownKeyFor @NonNull @Initialized Method evaluationMethod, @UnknownKeyFor @NonNull @Initialized Trigger trigger) {
            try {
                return (RunnerApi.Trigger)evaluationMethod.invoke((Object)this, trigger);
            }
            catch (InvocationTargetException exc) {
                if (exc.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)exc.getCause();
                }
                throw new RuntimeException(exc.getCause());
            }
            catch (IllegalAccessException exc) {
                throw new IllegalStateException(String.format("Internal error: could not invoke %s", evaluationMethod));
            }
        }

        private @UnknownKeyFor @NonNull @Initialized Method getEvaluationMethod(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
            try {
                return this.getClass().getDeclaredMethod("convertSpecific", clazz);
            }
            catch (NoSuchMethodException exc) {
                throw new IllegalArgumentException(String.format("Cannot translate trigger class %s to a runner-API proto.", clazz.getCanonicalName()), exc);
            }
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized DefaultTrigger v) {
            return RunnerApi.Trigger.newBuilder().setDefault(RunnerApi.Trigger.Default.getDefaultInstance()).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized AfterWatermark.FromEndOfWindow v) {
            return RunnerApi.Trigger.newBuilder().setAfterEndOfWindow(RunnerApi.Trigger.AfterEndOfWindow.getDefaultInstance()).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized Never.NeverTrigger v) {
            return RunnerApi.Trigger.newBuilder().setNever(RunnerApi.Trigger.Never.getDefaultInstance()).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized ReshuffleTrigger v) {
            return RunnerApi.Trigger.newBuilder().setAlways(RunnerApi.Trigger.Always.getDefaultInstance()).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized AfterSynchronizedProcessingTime v) {
            return RunnerApi.Trigger.newBuilder().setAfterSynchronizedProcessingTime(RunnerApi.Trigger.AfterSynchronizedProcessingTime.getDefaultInstance()).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized AfterFirst v) {
            RunnerApi.Trigger.AfterAny.Builder builder = RunnerApi.Trigger.AfterAny.newBuilder();
            for (Trigger subtrigger : v.subTriggers()) {
                builder.addSubtriggers(TriggerTranslation.toProto(subtrigger));
            }
            return RunnerApi.Trigger.newBuilder().setAfterAny(builder).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized AfterAll v) {
            RunnerApi.Trigger.AfterAll.Builder builder = RunnerApi.Trigger.AfterAll.newBuilder();
            for (Trigger subtrigger : v.subTriggers()) {
                builder.addSubtriggers(TriggerTranslation.toProto(subtrigger));
            }
            return RunnerApi.Trigger.newBuilder().setAfterAll(builder).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized AfterPane v) {
            return RunnerApi.Trigger.newBuilder().setElementCount(RunnerApi.Trigger.ElementCount.newBuilder().setElementCount(v.getElementCount())).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized AfterWatermark.AfterWatermarkEarlyAndLate v) {
            RunnerApi.Trigger.AfterEndOfWindow.Builder builder = RunnerApi.Trigger.AfterEndOfWindow.newBuilder();
            builder.setEarlyFirings(TriggerTranslation.toProto(v.getEarlyTrigger()));
            if (v.getLateTrigger() != null) {
                builder.setLateFirings(TriggerTranslation.toProto(v.getLateTrigger()));
            }
            return RunnerApi.Trigger.newBuilder().setAfterEndOfWindow(builder).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized AfterEach v) {
            RunnerApi.Trigger.AfterEach.Builder builder = RunnerApi.Trigger.AfterEach.newBuilder();
            for (Trigger subtrigger : v.subTriggers()) {
                builder.addSubtriggers(TriggerTranslation.toProto(subtrigger));
            }
            return RunnerApi.Trigger.newBuilder().setAfterEach(builder).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized Repeatedly v) {
            return RunnerApi.Trigger.newBuilder().setRepeat(RunnerApi.Trigger.Repeat.newBuilder().setSubtrigger(TriggerTranslation.toProto(v.getRepeatedTrigger()))).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized OrFinallyTrigger v) {
            return RunnerApi.Trigger.newBuilder().setOrFinally(RunnerApi.Trigger.OrFinally.newBuilder().setMain(TriggerTranslation.toProto(v.getMainTrigger())).setFinally(TriggerTranslation.toProto(v.getUntilTrigger()))).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger convertSpecific(@UnknownKeyFor @NonNull @Initialized AfterProcessingTime v) {
            RunnerApi.Trigger.AfterProcessingTime.Builder builder = RunnerApi.Trigger.AfterProcessingTime.newBuilder();
            for (TimestampTransform transform : v.getTimestampTransforms()) {
                builder.addTimestampTransforms(this.convertTimestampTransform(transform));
            }
            return RunnerApi.Trigger.newBuilder().setAfterProcessingTime(builder).build();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.TimestampTransform convertTimestampTransform(@UnknownKeyFor @NonNull @Initialized TimestampTransform transform) {
            if (transform instanceof TimestampTransform.Delay) {
                return RunnerApi.TimestampTransform.newBuilder().setDelay(RunnerApi.TimestampTransform.Delay.newBuilder().setDelayMillis(((TimestampTransform.Delay)transform).getDelay().getMillis())).build();
            }
            if (transform instanceof TimestampTransform.AlignTo) {
                TimestampTransform.AlignTo alignTo = (TimestampTransform.AlignTo)transform;
                return RunnerApi.TimestampTransform.newBuilder().setAlignTo(RunnerApi.TimestampTransform.AlignTo.newBuilder().setPeriod(alignTo.getPeriod().getMillis()).setOffset(alignTo.getOffset().getMillis())).build();
            }
            throw new IllegalArgumentException(String.format("Unknown %s: %s", TimestampTransform.class.getSimpleName(), transform));
        }
    }
}

