/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.context;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionFilter;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;

public abstract class BaseGuiContextHandler<T extends IGuiContextHandler> {
    public static final String CONTEXT_ID = "HopGuiPipelineTransformContext";

    public abstract String getContextId();

    protected List<GuiAction> getPluginActions(boolean sortActionsById) {
        ArrayList<GuiAction> actions = GuiRegistry.getInstance().getGuiContextActions(this.getContextId());
        if (Utils.isEmpty((Collection)actions)) {
            return Collections.emptyList();
        }
        List actionFilters = GuiRegistry.getInstance().getGuiContextActionFilters(this.getContextId());
        ArrayList<GuiAction> filteredActions = new ArrayList<GuiAction>();
        for (GuiAction action : actions) {
            boolean retain = true;
            if (actionFilters != null) {
                for (GuiActionFilter actionFilter : actionFilters) {
                    boolean retainAction = false;
                    try {
                        retainAction = this.evaluateActionFilter(action, actionFilter);
                        if (retainAction) continue;
                        retain = false;
                        break;
                    }
                    catch (HopException e) {
                        LogChannel.UI.logError("Error filtering out action " + action.getId() + " with filter " + actionFilter.getId(), (Throwable)e);
                    }
                }
            }
            if (!retain) continue;
            filteredActions.add(action);
        }
        actions = filteredActions;
        if (sortActionsById) {
            Collections.sort(actions, Comparator.comparing(GuiAction::getId));
        }
        return actions;
    }

    public ClassLoader findClassLoader(GuiActionFilter actionFilter) {
        if (actionFilter.getClassLoader() != null) {
            return actionFilter.getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    public Object getFilterObject(GuiActionFilter actionFilter) throws HopException {
        try {
            Object guiPlugin;
            ClassLoader classLoader = this.findClassLoader(actionFilter);
            Class<?> filterClass = classLoader.loadClass(actionFilter.getGuiPluginClassName());
            if (filterClass == null) {
                throw new HopException("Couldn't load class " + actionFilter.getGuiPluginClassName() + " for action filter " + actionFilter.getId());
            }
            try {
                Method getInstanceMethod = filterClass.getDeclaredMethod("getInstance", new Class[0]);
                guiPlugin = getInstanceMethod.invoke(null, (Object[])null);
            }
            catch (Exception nsme) {
                try {
                    guiPlugin = filterClass.newInstance();
                }
                catch (Exception e) {
                    throw nsme;
                }
            }
            return guiPlugin;
        }
        catch (Exception e) {
            throw new HopException("Error finding, loading or creating object for action filter " + actionFilter.getId(), (Throwable)e);
        }
    }

    public Method getFilterMethod(Class<?> filterClass, GuiActionFilter actionFilter) throws HopException {
        try {
            Method method = filterClass.getMethod(actionFilter.getGuiPluginMethodName(), String.class, this.getClass());
            if (method == null) {
                throw new HopException("Couldn't find method " + actionFilter.getGuiPluginMethodName() + " class " + actionFilter.getGuiPluginClassName() + " for action filter " + actionFilter.getId());
            }
            return method;
        }
        catch (Exception e) {
            throw new HopException("Error finding action filter method " + actionFilter.getId(), (Throwable)e);
        }
    }

    public boolean evaluateActionFilter(GuiAction action, GuiActionFilter actionFilter) throws HopException {
        try {
            Object guiPlugin = this.getFilterObject(actionFilter);
            Method method = this.getFilterMethod(guiPlugin.getClass(), actionFilter);
            return (Boolean)method.invoke(guiPlugin, action.getId(), this);
        }
        catch (Exception e) {
            throw new HopException("Error filtering out action with ID " + action.getId() + " against filter " + actionFilter.getId(), (Throwable)e);
        }
    }
}

