/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.history.AuditManager;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.GuiContextHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.HopFileTypeBase;
import org.apache.hop.ui.hopgui.file.HopFileTypePlugin;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.start.ActionStart;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@HopFileTypePlugin(id="HopFile-Workflow-Plugin", description="The workflow file information for the Hop GUI", image="ui/images/workflow.svg")
public class HopWorkflowFileType<T extends WorkflowMeta>
extends HopFileTypeBase {
    public static final Class<?> PKG = HopWorkflowFileType.class;
    public static final String WORKFLOW_FILE_TYPE_DESCRIPTION = "Workflow";
    public static final String CONST_FALSE = "false";
    public static final String ACTION_ID_NEW_WORKFLOW = "NewWorkflow";

    @Override
    public String getName() {
        return WORKFLOW_FILE_TYPE_DESCRIPTION;
    }

    @Override
    public String getDefaultFileExtension() {
        return ".hwf";
    }

    @Override
    public String[] getFilterExtensions() {
        return new String[]{"*.hwf"};
    }

    @Override
    public String[] getFilterNames() {
        return new String[]{"Workflows"};
    }

    @Override
    public Properties getCapabilities() {
        Properties capabilities = new Properties();
        capabilities.setProperty("New", "true");
        capabilities.setProperty("Close", "true");
        capabilities.setProperty("Start", "true");
        capabilities.setProperty("Stop", "true");
        capabilities.setProperty("Save", "true");
        capabilities.setProperty("SaveAs", "true");
        capabilities.setProperty("ExportToSvg", "true");
        capabilities.setProperty("Pause", CONST_FALSE);
        capabilities.setProperty("Preview", CONST_FALSE);
        capabilities.setProperty("Debug", CONST_FALSE);
        capabilities.setProperty("Select", "true");
        capabilities.setProperty("Copy", "true");
        capabilities.setProperty("Paste", "true");
        capabilities.setProperty("Cut", "true");
        capabilities.setProperty("Delete", "true");
        capabilities.setProperty("SnapToGrid", "true");
        capabilities.setProperty("AlignLeft", "true");
        capabilities.setProperty("AlignRight", "true");
        capabilities.setProperty("AlignTop", "true");
        capabilities.setProperty("AlignBottom", "true");
        capabilities.setProperty("DistributeHorizontal", "true");
        capabilities.setProperty("DistributeVertical", "true");
        capabilities.setProperty("FileHistory", "true");
        return capabilities;
    }

    @Override
    public IHopFileTypeHandler openFile(HopGui hopGui, String filename, IVariables variables) throws HopException {
        try {
            filename = HopVfs.normalize((String)variables.resolve(filename));
            IHopFileTypeHandler fileTypeHandler = HopGui.getExplorerPerspective().findFileTypeHandlerByFilename(filename);
            if (fileTypeHandler != null) {
                HopGui.getExplorerPerspective().setActiveFileTypeHandler(fileTypeHandler);
                return fileTypeHandler;
            }
            WorkflowMeta workflowMeta = new WorkflowMeta(variables, filename, (IHopMetadataProvider)hopGui.getMetadataProvider());
            IHopFileTypeHandler typeHandler = HopGui.getExplorerPerspective().addWorkflow(workflowMeta);
            AuditManager.registerEvent((String)HopNamespace.getNamespace(), (String)"file", (String)filename, (String)"open");
            ExtensionPointHandler.callExtensionPoint((ILogChannel)hopGui.getLog(), (IVariables)variables, (String)HopExtensionPoint.WorkflowAfterOpen.id, (Object)workflowMeta);
            return typeHandler;
        }
        catch (Exception e) {
            throw new HopException("Error opening workflow file '" + filename + "'", (Throwable)e);
        }
    }

    @Override
    public IHopFileTypeHandler newFile(HopGui hopGui, IVariables parentVariableSpace) throws HopException {
        try {
            WorkflowMeta workflowMeta = new WorkflowMeta();
            workflowMeta.setName(BaseMessages.getString(PKG, (String)"HopWorkflowFileType.New.Text", (String[])new String[0]));
            workflowMeta.setMetadataProvider((IHopMetadataProvider)hopGui.getMetadataProvider());
            ActionStart start = new ActionStart("Start");
            ActionMeta startMeta = new ActionMeta((IAction)start);
            startMeta.setLocation(50, 50);
            workflowMeta.addAction(startMeta);
            IHopFileTypeHandler fileHandler = HopGui.getExplorerPerspective().addWorkflow(workflowMeta);
            if (fileHandler instanceof HopGuiWorkflowGraph) {
                ((HopGuiWorkflowGraph)fileHandler).updateGui();
            }
            HopGui.getExplorerPerspective().activate();
            return fileHandler;
        }
        catch (Exception e) {
            throw new HopException("Error creating new workflow", (Throwable)e);
        }
    }

    @Override
    public boolean isHandledBy(String filename, boolean checkContent) throws HopException {
        try {
            if (checkContent) {
                Document document = XmlHandler.loadXmlFile((String)filename);
                Node workflowNode = XmlHandler.getSubNode((Node)document, (String)"workflow");
                return workflowNode != null;
            }
            return super.isHandledBy(filename, checkContent);
        }
        catch (Exception e) {
            throw new HopException("Unable to verify file handling of file '" + filename + "'", (Throwable)e);
        }
    }

    @Override
    public boolean supportsFile(IHasFilename metaObject) {
        return metaObject instanceof WorkflowMeta;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        HopGui hopGui = HopGui.getInstance();
        ArrayList<IGuiContextHandler> handlers = new ArrayList<IGuiContextHandler>();
        GuiAction newAction = new GuiAction(ACTION_ID_NEW_WORKFLOW, GuiActionType.Create, BaseMessages.getString(PKG, (String)"HopWorkflowFileType.GuiAction.Workflow.Name", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopWorkflowFileType.GuiAction.Workflow.Tooltip", (String[])new String[0]), "ui/images/workflow.svg", (shiftClicked, controlClicked, parameters) -> {
            try {
                this.newFile(hopGui, hopGui.getVariables());
            }
            catch (Exception e) {
                new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"HopWorkflowFileType.ErrorDialog.NewWorkflowCreation.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopWorkflowFileType.ErrorDialog.NewWorkflowCreation.Message", (String[])new String[0]), e);
            }
        });
        newAction.setCategory("File");
        newAction.setCategoryOrder("1");
        handlers.add(new GuiContextHandler(ACTION_ID_NEW_WORKFLOW, List.of(newAction)));
        return handlers;
    }

    @Override
    public String getFileTypeImage() {
        return "ui/images/workflow.svg";
    }
}

