/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.configuration;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.tab.GuiTabItem;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.configuration.tabs.ConfigPluginOptionsTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@HopPerspectivePlugin(id="160-HopConfigurationPerspective", name="i18n::ConfigurationPerspective.Name", description="i18n::ConfigurationPerspective.Description", image="ui/images/gear.svg", documentationUrl="/hop-gui/perspective-configuration.html")
@GuiPlugin(name="i18n::ConfigurationPerspective.Name", description="i18n::HopConfigurationPerspective.GuiPlugin.Description")
public class ConfigurationPerspective
implements IHopPerspective {
    private static final Class<?> PKG = ConfigurationPerspective.class;
    public static final String CONFIG_PERSPECTIVE_TABS = "ConfigurationPerspective.Tabs.ID";
    private static final String ORIGINAL = "Original";
    private static final String ORIGINAL_BACKGROUND = "BackgroundColor";
    private static final String ORIGINAL_FONT = "Font";
    private HopGui hopGui;
    private SashForm sashForm;
    public CTabFolder configTabs;
    private Tree categoryTree;
    private Map<String, CTabItem> categoryTabs = new HashMap<String, CTabItem>();
    private List<Object> tabInstances = new ArrayList<Object>();
    private List<Control> highlightedControls = new ArrayList<Control>();
    private String currentSearchText = "";
    private Color highlightColor;
    private static ConfigurationPerspective instance;

    public ConfigurationPerspective() {
        instance = this;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return new ArrayList<IGuiContextHandler>();
    }

    @Override
    public String getId() {
        return "configuration";
    }

    @Override
    @GuiKeyboardShortcut(control=true, shift=true, key=99)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=99)
    public void activate() {
        this.hopGui.setActivePerspective(this);
    }

    @Override
    public void perspectiveActivated() {
        this.reloadAllTabValues();
    }

    private void reloadAllTabValues() {
        for (Object tabInstance : this.tabInstances) {
            try {
                Method reloadMethod = tabInstance.getClass().getMethod("reloadValues", new Class[0]);
                reloadMethod.invoke(tabInstance, new Object[0]);
            }
            catch (NoSuchMethodException reloadMethod) {
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error message", new Object[]{"Error reloading values for tab " + tabInstance.getClass().getName() + ": " + e.getMessage()});
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.hopGui.isActivePerspective(this);
    }

    @Override
    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        this.highlightColor = GuiResource.getInstance().getColorLightBlue();
        this.sashForm = new SashForm(parent, 65792);
        PropsUi.setLook((Widget)this.sashForm);
        this.sashForm.setLayoutData((Object)new FormDataBuilder().fullSize().result());
        Composite treeComposite = new Composite((Composite)this.sashForm, 0);
        PropsUi.setLook((Widget)treeComposite);
        treeComposite.setLayout((Layout)new FormLayout());
        Text searchBox = new Text(treeComposite, 2944);
        PropsUi.setLook((Widget)searchBox);
        searchBox.setMessage(BaseMessages.getString(PKG, (String)"HopConfigurationperspective.Search.Text", (String[])new String[0]));
        searchBox.setLayoutData((Object)new FormDataBuilder().top().fullWidth().result());
        searchBox.addListener(24, e -> this.filterSettings(searchBox.getText()));
        this.categoryTree = new Tree(treeComposite, 2564);
        this.categoryTree.setLayoutData((Object)new FormDataBuilder().top((Control)searchBox, PropsUi.getMargin()).bottom().fullWidth().result());
        PropsUi.setLook((Widget)this.categoryTree, 7);
        this.categoryTree.addListener(13, e -> {
            TreeItem[] selection = this.categoryTree.getSelection();
            if (selection.length > 0) {
                TreeItem selectedItem = selection[0];
                Boolean isPlugin = (Boolean)selectedItem.getData("isPlugin");
                if (isPlugin != null && isPlugin.booleanValue()) {
                    String pluginName = (String)selectedItem.getData("pluginName");
                    TreeItem parentItem = selectedItem.getParentItem();
                    if (parentItem != null) {
                        Composite tabComposite;
                        Composite pluginComposite;
                        Control tabControl;
                        this.showCategory(parentItem.getText(), false);
                        CTabItem pluginTab = this.categoryTabs.get(parentItem.getText());
                        if (pluginTab != null && (tabControl = pluginTab.getControl()) instanceof Composite && (pluginComposite = this.findPluginComposite(tabComposite = (Composite)tabControl)) != null) {
                            ConfigPluginOptionsTab.showConfigPluginSettings(pluginName, pluginComposite);
                            if (this.currentSearchText != null && !this.currentSearchText.trim().isEmpty()) {
                                this.applyHighlightingToCurrentTab();
                            }
                        }
                    }
                } else {
                    Composite tabComposite;
                    Composite pluginComposite;
                    Control tabControl;
                    CTabItem pluginTab;
                    String categoryName = selectedItem.getText();
                    this.showCategory(categoryName, true);
                    if ((categoryName.equalsIgnoreCase("Plugins") || categoryName.contains("plugin")) && (pluginTab = this.categoryTabs.get(categoryName)) != null && (tabControl = pluginTab.getControl()) instanceof Composite && (pluginComposite = this.findPluginComposite(tabComposite = (Composite)tabControl)) != null) {
                        ConfigPluginOptionsTab.showPluginInstructions(pluginComposite);
                    }
                }
            }
        });
        this.configTabs = new CTabFolder((Composite)this.sashForm, 2048);
        PropsUi.setLook((Widget)this.configTabs, 4);
        this.configTabs.setTabHeight(0);
        this.loadSettingCategories();
        this.sashForm.setWeights(new int[]{20, 80});
    }

    private void loadSettingCategories() {
        GuiRegistry guiRegistry = GuiRegistry.getInstance();
        List tabsList = (List)guiRegistry.getGuiTabsMap().get(CONFIG_PERSPECTIVE_TABS);
        if (tabsList != null) {
            CTabItem[] allTabs;
            tabsList.sort(Comparator.comparing(GuiTabItem::getId));
            for (GuiTabItem tabItem : tabsList) {
                try {
                    Object object = tabItem.getMethod().getDeclaringClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    tabItem.getMethod().invoke(object, this.configTabs);
                    this.tabInstances.add(object);
                }
                catch (Exception e) {
                    new ErrorDialog(this.hopGui.getShell(), "Error", "Hop was unable to invoke @GuiTab method " + tabItem.getMethod().getName() + " with the parent composite as argument", e);
                }
            }
            for (CTabItem tab : allTabs = this.configTabs.getItems()) {
                String categoryName = tab.getText();
                if (categoryName.equalsIgnoreCase("Plugins") || categoryName.contains("plugin")) {
                    TreeItem pluginsTreeItem = new TreeItem(this.categoryTree, 0);
                    pluginsTreeItem.setText(categoryName);
                    if (tab.getImage() != null) {
                        pluginsTreeItem.setImage(tab.getImage());
                    }
                    this.categoryTabs.put(categoryName, tab);
                    this.expandPluginsIntoTree(tab, pluginsTreeItem);
                    continue;
                }
                TreeItem treeItem = new TreeItem(this.categoryTree, 0);
                treeItem.setText(categoryName);
                if (tab.getImage() != null) {
                    treeItem.setImage(tab.getImage());
                }
                this.categoryTabs.put(categoryName, tab);
            }
            if (this.categoryTree.getItemCount() > 0) {
                this.categoryTree.setSelection(this.categoryTree.getItem(0));
                this.showCategory(this.categoryTree.getItem(0).getText());
            }
        }
    }

    private void expandPluginsIntoTree(CTabItem pluginTab, TreeItem parentItem) {
        this.categoryTabs.put(parentItem.getText(), pluginTab);
        Set<String> pluginNames = ConfigPluginOptionsTab.getPluginNames();
        if (pluginNames != null && !pluginNames.isEmpty()) {
            for (String pluginName : pluginNames) {
                TreeItem pluginItem = new TreeItem(parentItem, 0);
                pluginItem.setText(pluginName);
                pluginItem.setData("pluginName", (Object)pluginName);
                pluginItem.setData("isPlugin", (Object)true);
            }
            parentItem.setExpanded(true);
        }
    }

    private void showCategory(String categoryName) {
        this.showCategory(categoryName, true);
    }

    private void showCategory(String categoryName, boolean applyHighlighting) {
        CTabItem tab = this.categoryTabs.get(categoryName);
        if (tab != null && !tab.isDisposed()) {
            this.configTabs.setSelection(tab);
            this.configTabs.layout();
            if (applyHighlighting && this.currentSearchText != null && !this.currentSearchText.trim().isEmpty()) {
                this.applyHighlightingToCurrentTab();
            }
        }
    }

    private void filterSettings(String searchText) {
        String string = this.currentSearchText = searchText != null ? searchText.trim() : "";
        if (this.currentSearchText.length() < 3) {
            this.currentSearchText = "";
        }
        this.clearHighlights();
        if (this.currentSearchText.isEmpty()) {
            for (TreeItem item : this.categoryTree.getItems()) {
                item.setFont(null);
                for (TreeItem child : item.getItems()) {
                    child.setFont(null);
                }
            }
            return;
        }
        String lowerSearch = this.currentSearchText.toLowerCase();
        TreeItem firstMatch = null;
        for (TreeItem item : this.categoryTree.getItems()) {
            Composite controlComposite;
            List<Control> matches;
            Control control;
            CTabItem tab;
            String categoryName = item.getText().toLowerCase();
            boolean categoryMatches = categoryName.contains(lowerSearch);
            boolean hasMatchingContent = false;
            if (categoryMatches) {
                item.setForeground(null);
                if (firstMatch == null) {
                    firstMatch = item;
                }
            }
            if ((tab = this.categoryTabs.get(item.getText())) != null && !tab.isDisposed() && (control = tab.getControl()) instanceof Composite && !(matches = this.searchInComposite(controlComposite = (Composite)control, lowerSearch)).isEmpty()) {
                hasMatchingContent = true;
                if (firstMatch == null) {
                    firstMatch = item;
                }
                for (Control match : matches) {
                    this.highlightControl(match, this.highlightColor);
                }
            }
            boolean hasMatchingPlugin = false;
            for (TreeItem childItem : item.getItems()) {
                String pluginName = childItem.getText();
                String pluginNameLower = pluginName.toLowerCase();
                boolean pluginMatches = pluginNameLower.contains(lowerSearch);
                boolean pluginContentMatches = this.searchInPluginContent(pluginName, lowerSearch);
                if (pluginMatches || pluginContentMatches) {
                    childItem.setFont(GuiResource.getInstance().getFontBold());
                    hasMatchingPlugin = true;
                    if (firstMatch != null) continue;
                    firstMatch = childItem;
                    continue;
                }
                childItem.setFont(null);
            }
            if (categoryMatches || hasMatchingContent || hasMatchingPlugin) {
                item.setFont(GuiResource.getInstance().getFontBold());
                item.setExpanded(true);
                continue;
            }
            item.setFont(null);
        }
        if (firstMatch != null) {
            this.categoryTree.setSelection(firstMatch);
            this.categoryTree.showSelection();
            Event event = new Event();
            event.item = firstMatch;
            this.categoryTree.notifyListeners(13, event);
            this.hopGui.getDisplay().timerExec(100, () -> {
                Control control;
                CTabItem selectedTab = this.configTabs.getSelection();
                if (selectedTab != null && !selectedTab.isDisposed() && (control = selectedTab.getControl()) instanceof Composite) {
                    Composite controlComposite = (Composite)control;
                    if (!control.isDisposed()) {
                        List<Control> matches = this.searchInComposite(controlComposite, lowerSearch);
                        for (Control match : matches) {
                            if (match.isDisposed()) continue;
                            this.highlightControl(match, this.highlightColor);
                        }
                        if (!control.isDisposed()) {
                            control.redraw();
                        }
                    }
                }
            });
        }
    }

    private boolean searchInPluginContent(String pluginName, String searchText) {
        Composite tempComposite = new Composite((Composite)this.sashForm, 0);
        tempComposite.setLayout((Layout)new FillLayout());
        try {
            ConfigPluginOptionsTab.showConfigPluginSettings(pluginName, tempComposite);
            tempComposite.layout(true, true);
            List<Control> matches = this.searchInComposite(tempComposite, searchText);
            tempComposite.dispose();
            return !matches.isEmpty();
        }
        catch (Exception e) {
            if (!tempComposite.isDisposed()) {
                tempComposite.dispose();
            }
            return false;
        }
    }

    private List<Control> searchInComposite(Composite composite, String searchText) {
        ArrayList<Control> matches = new ArrayList<Control>();
        if (composite == null || composite.isDisposed()) {
            return matches;
        }
        if (searchText == null || searchText.trim().isEmpty()) {
            return matches;
        }
        try {
            for (Control control : composite.getChildren()) {
                String tooltip;
                if (control == null || control.isDisposed()) continue;
                boolean controlMatches = false;
                if (control instanceof Label) {
                    Label label = (Label)control;
                    String string = label.getText();
                    if (string != null && string.toLowerCase().contains(searchText)) {
                        matches.add(control);
                        controlMatches = true;
                    }
                } else if (control instanceof Text) {
                    Text text = (Text)control;
                    String string = text.getText();
                    if (string != null && string.toLowerCase().contains(searchText)) {
                        matches.add(control);
                        controlMatches = true;
                    }
                } else if (control instanceof Button) {
                    Button button = (Button)control;
                    String string = button.getText();
                    if (string != null && string.toLowerCase().contains(searchText)) {
                        matches.add(control);
                        controlMatches = true;
                    }
                } else if (control instanceof Table) {
                    Table table = (Table)control;
                    for (TableItem item : table.getItems()) {
                        for (int i = 0; i < table.getColumnCount(); ++i) {
                            String cellText = item.getText(i);
                            if (cellText == null || !cellText.toLowerCase().contains(searchText)) continue;
                            matches.add(control);
                            controlMatches = true;
                            break;
                        }
                        if (!controlMatches) {
                            continue;
                        }
                        break;
                    }
                } else if (control instanceof TableView) {
                    TableView tableView = (TableView)control;
                    Table table = tableView.table;
                    for (TableItem item : table.getItems()) {
                        for (int i = 0; i < table.getColumnCount(); ++i) {
                            String cellText = item.getText(i);
                            if (cellText == null || !cellText.toLowerCase().contains(searchText)) continue;
                            matches.add(control);
                            controlMatches = true;
                            break;
                        }
                        if (!controlMatches) {
                            continue;
                        }
                        break;
                    }
                }
                if (!controlMatches && (tooltip = control.getToolTipText()) != null && tooltip.toLowerCase().contains(searchText)) {
                    matches.add(control);
                    controlMatches = true;
                }
                if (control instanceof ScrolledComposite) {
                    ScrolledComposite sc = (ScrolledComposite)control;
                    Control content = sc.getContent();
                    if (!(content instanceof Composite)) continue;
                    Composite composite1 = (Composite)content;
                    matches.addAll(this.searchInComposite(composite1, searchText));
                    continue;
                }
                if (!(control instanceof Composite)) continue;
                Composite composite1 = (Composite)control;
                matches.addAll(this.searchInComposite(composite1, searchText));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return matches;
    }

    private void highlightControl(Control control, Color highlightColor) {
        Font currentFont;
        if (control == null || control.isDisposed()) {
            return;
        }
        if (control instanceof Table) {
            Table table = (Table)control;
            this.highlightTableRows(table, highlightColor);
            return;
        }
        if (control instanceof TableView) {
            TableView tableView = (TableView)control;
            this.highlightTableRows(tableView.table, highlightColor);
            return;
        }
        if (control.getData(ORIGINAL) == null) {
            control.setData(ORIGINAL, (Object)Boolean.TRUE);
            control.setData(ORIGINAL_BACKGROUND, (Object)control.getBackground());
            control.setData(ORIGINAL_FONT, (Object)control.getFont());
        }
        control.setBackground(highlightColor);
        if ((control instanceof Label || control instanceof Text) && (currentFont = control.getFont()) != null) {
            FontData[] fontData;
            for (FontData fd : fontData = currentFont.getFontData()) {
                fd.setStyle(fd.getStyle() | 1);
            }
            Font boldFont = new Font((Device)control.getDisplay(), fontData);
            control.setFont(boldFont);
        }
        this.highlightedControls.add(control);
    }

    private void highlightTableRows(Table table, Color highlightColor) {
        if (table == null || table.isDisposed() || this.currentSearchText == null || this.currentSearchText.trim().isEmpty()) {
            return;
        }
        String lowerSearch = this.currentSearchText.toLowerCase();
        for (TableItem item : table.getItems()) {
            boolean rowMatches = false;
            for (int i = 0; i < table.getColumnCount(); ++i) {
                String cellText = item.getText(i);
                if (cellText == null || !cellText.toLowerCase().contains(lowerSearch)) continue;
                rowMatches = true;
                break;
            }
            if (!rowMatches) continue;
            item.setData(ORIGINAL_BACKGROUND, (Object)item.getBackground());
            item.setBackground(highlightColor);
            if (this.highlightedControls.contains(table)) continue;
            this.highlightedControls.add((Control)table);
        }
    }

    private void clearHighlights() {
        for (Control control : this.highlightedControls) {
            Font originalFont;
            if (control.isDisposed()) continue;
            if (control instanceof Table) {
                Table table = (Table)control;
                for (TableItem item : table.getItems()) {
                    if (item.isDisposed()) continue;
                    item.setBackground(null);
                }
                continue;
            }
            Color originalBg = (Color)control.getData(ORIGINAL_BACKGROUND);
            if (originalBg != null) {
                control.setBackground(originalBg);
            }
            if ((originalFont = (Font)control.getData(ORIGINAL_FONT)) == null) continue;
            Font currentFont = control.getFont();
            control.setFont(originalFont);
            if (currentFont == null || currentFont.equals((Object)originalFont)) continue;
            currentFont.dispose();
        }
        this.highlightedControls.clear();
    }

    private void applyHighlightingToCurrentTab() {
        if (this.currentSearchText == null || this.currentSearchText.trim().isEmpty()) {
            return;
        }
        String lowerSearch = this.currentSearchText.toLowerCase();
        this.hopGui.getDisplay().timerExec(100, () -> {
            Control control;
            this.clearHighlights();
            CTabItem selectedTab = this.configTabs.getSelection();
            if (selectedTab != null && !selectedTab.isDisposed() && (control = selectedTab.getControl()) instanceof Composite) {
                Composite composite1 = (Composite)control;
                if (!control.isDisposed()) {
                    List<Control> matches = this.searchInComposite(composite1, lowerSearch);
                    for (Control match : matches) {
                        if (match.isDisposed()) continue;
                        this.highlightControl(match, this.highlightColor);
                    }
                    if (!control.isDisposed()) {
                        control.redraw();
                    }
                }
            }
        });
    }

    public void showSystemVariablesTab() {
        for (TreeItem item : this.categoryTree.getItems()) {
            if (!item.getText().toLowerCase().contains("variable")) continue;
            this.categoryTree.setSelection(item);
            this.showCategory(item.getText());
            break;
        }
    }

    @Override
    public Control getControl() {
        return this.sashForm;
    }

    private Composite findPluginComposite(Composite parent) {
        for (Control child : parent.getChildren()) {
            Composite found;
            if (!(child instanceof Composite)) continue;
            Composite childComposite = (Composite)child;
            Object layoutData = childComposite.getLayoutData();
            if (layoutData instanceof FormData) {
                FormData fd = (FormData)layoutData;
                if (fd.left != null && fd.right != null && fd.top != null && fd.bottom != null) {
                    return childComposite;
                }
            }
            if ((found = this.findPluginComposite(childComposite)) == null) continue;
            return found;
        }
        return null;
    }

    @Generated
    public static ConfigurationPerspective getInstance() {
        return instance;
    }
}

