/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.concurrent.locks.ReentrantLock;

public class Counter {
    private long counterValue = this.start;
    private long start = 1L;
    private long increment = 1L;
    private long maximum = 0L;
    private boolean loop = false;
    private ReentrantLock lock = new ReentrantLock();

    public Counter() {
    }

    public Counter(long start) {
        this();
        this.start = start;
        this.counterValue = start;
        this.lock = new ReentrantLock();
    }

    public Counter(long start, long increment) {
        this(start);
        this.increment = increment;
    }

    public Counter(long start, long increment, long maximum) {
        this(start, increment);
        this.loop = true;
        this.maximum = maximum;
    }

    public long getCounter() {
        return this.counterValue;
    }

    public long getIncrement() {
        return this.increment;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public long getStart() {
        return this.start;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setCounter(long counter) {
        this.counterValue = counter;
    }

    public void setIncrement(long increment) {
        this.increment = increment;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setMaximum(long maximum) {
        this.maximum = maximum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndNext() {
        this.lock.lock();
        try {
            long value = this.counterValue;
            long nextValue = this.counterValue + this.increment;
            if (this.loop) {
                if (this.increment < 0L) {
                    if (this.maximum < this.start && nextValue < this.maximum) {
                        nextValue = this.start;
                    }
                } else if (this.increment > 0L && this.maximum > this.start && nextValue > this.maximum) {
                    nextValue = this.start;
                }
            }
            this.counterValue = nextValue;
            long l = value;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

